/* 	Test forcing Fl to draw in different visuals:

	This is also a good way to test the colormap allocation
	functions in fl_color.C

*/

#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Button.H>
#include <FL/fl_show_colormap.H>
#include <FL/x.H>

#include <stdlib.h>
#include <stdio.h>
#include "list_visuals.C"

int c = FL_GRAY;

void cb(Fl_Object *ob, void *) {
  c = fl_show_colormap(c);
  ob->parent()->color(c,c);
  ob->parent()->redraw();
}

int main(int argc, char ** argv) {
  Fl_Window *window = new Fl_Double_Window(400,400);
  Fl_Button *b = new Fl_Button(140,160,120,80,"Push Me");
  window->add(b);
  b->callback(cb);
  int visid = 0;
  int i = 1;
  if (!Fl::args(argc,argv,i) || i != argc-1) {
    printf("usage: %s <switches> visual-number\n"
	   " - : default visual\n",argv[0]);
    list_visuals();
    puts(Fl::help);
    exit(1);
  }
  if (argv[i][0] != '-') {
    visid = atoi(argv[i]);
    fl_open_display();
    XVisualInfo templt; int num;
    templt.visualid = visid;
    fl_visual = XGetVisualInfo(fl_display, VisualIDMask, &templt, &num);
    if (!fl_visual) Fl::abort("No visual with id %d",visid);
    fl_colormap = XCreateColormap(fl_display, RootWindow(fl_display,fl_screen),
				  fl_visual->visual, AllocNone);
    fl_xpixel(0); // make sure black is allocated
  }
  window->show(argc,argv);
  for (;;) Fl::wait();
}
