// 	Test the sliders & callbacks

#include <stdlib.h>
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Hor_Slider.H>
#include <FL/Fl_Hor_Fill_Slider.H>
#include <FL/Fl_Hor_Nice_Slider.H>
#include <FL/Fl_Hor_Value_Slider.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Toggle_Button.H>
#include <stdio.h>

void cb(Fl_Object *ob) {
  printf("Callback for %s\n",ob->label());
}

int when = 0;
int numsliders;
Fl_Slider *sliders[100];

void toggle_cb(Fl_Object *o, long v) {
  if (((Fl_Toggle_Button*)o)->value()) when |= v; else when &= ~v;
  for (int i=0; i<numsliders; i++) sliders[i]->when(when);
}

void button_cb(Fl_Object *,void *) {
  for (int i=0; i<numsliders; i++) {
    if (sliders[i]->changed()) {
      sliders[i]->clear_changed();
      printf("%s\n",sliders[i]->label());
    }
  }
}

int y;

void setup(Fl_Slider *s) {
  sliders[numsliders++] = s;
  s->when(0);
  s->callback(cb);
  s->align(FL_ALIGN_LEFT);
  s->labelsize(10);
  s->resize(100,y,290,20); y += 30;
  //s->slider(FL_THIN_UP_BOX);
}

int main(int argc, char **argv) {
  Fl_Window *window = new Fl_Window(400,400,argv[0]);
  window->begin();

  y = 20;
  setup(new Fl_Hor_Slider(10,y,300,20,"Fl_Hor_Slider"));
  setup(new Fl_Hor_Fill_Slider(10,y,300,20,"Fl_Hor_Fill_Slider"));
  setup(new Fl_Hor_Nice_Slider(10,y,300,20,"Fl_Hor_Nice_Slider"));
  Fl_Slider *s;
  setup(s = new Fl_Hor_Slider(10,y,300,20,"steps"));
  s->bounds(0,5); s->step(1); s->size(1.0/5);
  setup(s = new Fl_Hor_Slider(10,y,300,20,"degenerate"));
  s->bounds(1,1);
  setup(s = new Fl_Hor_Slider(10,y,300,20,"filled"));
  s->size(1);
  setup(s = new Fl_Hor_Slider(10,y,300,20,"label"));
  s->align(0); s->size(.2);
  setup(new Fl_Hor_Value_Slider(10,y,300,20,"Fl_Hor_Value_Slider"));
  window->resizable(s);

  Fl_Button *b;
  b = new Fl_Toggle_Button(10,y,200,20,"FL_WHEN_CHANGED");
  b->callback(toggle_cb, FL_WHEN_CHANGED); y += 20;
  b = new Fl_Toggle_Button(10,y,200,20,"FL_WHEN_RELEASE");
  b->callback(toggle_cb, FL_WHEN_RELEASE); y += 20;
  b = new Fl_Toggle_Button(10,y,200,20,"FL_WHEN_NOT_CHANGED");
  b->callback(toggle_cb, FL_WHEN_NOT_CHANGED); y += 20;
  y += 5;
  b = new Fl_Button(10,y,200,20,"print changed()");
  b->callback(button_cb);

  window->end();
  window->show(argc,argv);
  for (;;) Fl::wait();
}
