/*	Test the Fl_Overlay_Window	*/

#include <stdlib.h>
#include <stdio.h>
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Overlay_Window.H>
#include <FL/Fl_Button.H>
#include <FL/fl_draw.H>

int width=10,height=10;

class overlay : public Fl_Overlay_Window {
public:
  overlay(int w,int h,const char *l) : Fl_Overlay_Window(w,h,l) {}
  void draw_overlay();
};

void overlay::draw_overlay() {
  fl_color(FL_RED); fl_rect((w()-width)/2,(h()-height)/2,width,height);
}

overlay *ovl;

void bcb1(Fl_Object *,void *) {width+=20; ovl->redraw_overlay();}
void bcb2(Fl_Object *,void *) {width-=20; ovl->redraw_overlay();}
void bcb3(Fl_Object *,void *) {height+=20; ovl->redraw_overlay();}
void bcb4(Fl_Object *,void *) {height-=20; ovl->redraw_overlay();}

int main(int argc, char **argv) {
  ovl = new overlay(400,400,argv[0]);
  Fl_Button *b;
  b = new Fl_Button(50,50,100,100,"wider\n(a)");
  b->callback(bcb1); b->shortcut("a"); ovl->add(b);
  b = new Fl_Button(250,50,100,100,"narrower\n(b)");
  b->callback(bcb2); b->shortcut("b"); ovl->add(b);
  b = new Fl_Button(50,250,100,100,"taller\n(c)");
  b->callback(bcb3); b->shortcut("c"); ovl->add(b);
  b = new Fl_Button(250,250,100,100,"shorter\n(d)");
  b->callback(bcb4); b->shortcut("d"); ovl->add(b);
  ovl->resizable(ovl);
  ovl->show(argc,argv);
  ovl->redraw_overlay();
  for (;;) Fl::wait();
}
