#include <FL/Fl.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void test_cb(Fl_Object *,void *i) {printf("Callback %d\n",(int)i);}
void the_cb(Fl_Object *,void *i) {printf("Callback %d\n",(int)i);}
void quit_cb(Fl_Object *,void *) {exit(0);}
void shortcut_cb(Fl_Object *,void *v) {puts((char *)v);}

// here is how to turn the checkmarks in a menu item on/off:
void radio_cb(Fl_Object *o, void *) {
  Fl_Menu_* m = (Fl_Menu_*)o;
  Fl_Menu* i = (Fl_Menu*)(m->mvalue()); // get the menu item
  //  if (!i || !i->flags&FL_PUP_RADIO) return; // this should not happen
  if (i->flags & FL_PUP_CHECK) { // same item picked
    printf("radio item %s picked again\n", i->text);
    return;
  }
  printf("radio item %s picked\n", i->text);
  i->flags = i->flags | FL_PUP_RADIO | FL_PUP_CHECK;
  Fl_Menu* j;
  for (j = i; ; ) {	// go down
    if (j->text[0] == '_') break; // stop on divider lines
    j++;
    if (!j->text || !(j->flags&FL_PUP_RADIO)) break; // stop after group
    j->flags &= ~(FL_PUP_CHECK); // turn off check
  }
  for (j = i-1; ; j--) { // go up
    if (!j->text || j->text[0]=='_' || !(j->flags&FL_PUP_RADIO)) break;
    j->flags &= ~(FL_PUP_CHECK);
  }
}

Fl_Menu hugemenu[100];

Fl_Menu menutable[] = {
  {"/&File"},
    {"&Open",	"#o",	test_cb},
    {"&Close",	0,	test_cb},
    {"_&Quit",	"#q",	quit_cb},
    {"shortcut","^A",	shortcut_cb, (void*)"^A"},
    {"shortcut","^m",	shortcut_cb, (void*)"^m"},
    {"shortcut","^M",	shortcut_cb, (void*)"^M"},
    {"shortcut","#A",	shortcut_cb, (void*)"#A"},
    {"shortcut","#a",	shortcut_cb, (void*)"#a"},
    {"shortcut","F1",	shortcut_cb, (void*)"F1"},
    {"shortcut","+F1",	shortcut_cb, (void*)"+F1"},
    {"shortcut","^F1",	shortcut_cb, (void*)"^F1"},
    {"shortcut","#F1",	shortcut_cb, (void*)"#F1"},
    {"shortcut","#+^F1",shortcut_cb, (void*)"#+^F1"},
    {0},
  {"/&Edit"},
    {"Undo",	"#z",	test_cb},
    {"_Redo",	"#r",	test_cb},
    {"Cut",	"#x",	test_cb},
    {"Copy",	"#c",	test_cb},
    {"Paste",	"#v",	test_cb},
    {"Inactive","#d",	test_cb, 0,		FL_PUP_GREY},
    {"_Clear",	0,	test_cb},
    {"Invisible","#e",	test_cb, 0,		FL_PUP_INVISIBLE},
    {"Preferences",0,	test_cb},
    {"Size",	0,	test_cb},
    {0},
  {"/&Radio"},
    {"&Alpha",	0,	radio_cb, (void *)1,	FL_PUP_RADIO},
    {"&Beta",	0,	radio_cb, (void *)2,	FL_PUP_RADIO},
    {"&Gamma",	0,	radio_cb, (void *)3,	FL_PUP_RADIO},
    {"&Delta",	0,	radio_cb, (void *)4,	FL_PUP_RADIO|FL_PUP_CHECK},
    {"&Epsilon",0,	radio_cb, (void *)5,	FL_PUP_RADIO},
    {"&Pi",	0,	radio_cb, (void *)6,	FL_PUP_RADIO},
    {"_&Mu",	0,	radio_cb, (void *)7,	FL_PUP_RADIO},
    {"Red",	0,	radio_cb, (void *)1,	FL_PUP_RADIO},
    {"_Black",	0,	radio_cb, (void *)1,	FL_PUP_RADIO},
    {"00",	0,	radio_cb, (void *)1,	FL_PUP_RADIO},
    {"000",	0,	radio_cb, (void *)1,	FL_PUP_RADIO},
    {0},
  {"/E&mpty"},
    {0},
  {"/&Inactive",0,	0, 0,			FL_PUP_GREY},
    {"A very long menu item"},
    {"A very long menu item"},
    {0},
  {"/Invisible",0,	0, 0,			FL_PUP_INVISIBLE},
    {"A very long menu item"},
    {"A very long menu item"},
    {0},
  {"&Huge", 0, 0, (void*)hugemenu, FL_PUP_SUBMENU},
  {"/&Submenus","#S",	shortcut_cb, (void*)"Submenus"},
    {"A very long menu item"},
    {"/&submenu","^s",	shortcut_cb, (void*)"submenus"},
	{"item 1"},
	{"item 2"},
	{"item 3"},
	{"item 4"},
	{0},
    {"after submenu"},
    {0},
  {"button",	0,	the_cb},
  {0}
};

Fl_Menu pulldown[] = {
  {"Red",	"#r"},
  {"Green",	"#g"},
  {"Blue",	"#b"},
  {"Strange",	"#s"},
  {"Charm",	"#c"},
  {"Truth",	"#t"},
  {"Beauty",	"#b"},
  {0}
};

#define WIDTH 600

int main(int argc, char **argv) {
  for (int i=0; i<99; i++) {
    char buf[100];
    sprintf(buf,"item %d",i);
    hugemenu[i].text = strdup(buf);
  }
  Fl_Window window(WIDTH,400);
  Fl_Menu_Bar menubar(0,0,WIDTH,30); menubar.menu(menutable);
  window.add(menubar);
  Fl_Menu_Button mb1(100,100,120,25,"&menubutton"); mb1.menu(pulldown);
  window.add(mb1);
  Fl_Choice ch(300,100,80,25,"&choice:"); ch.menu(pulldown);
  window.add(ch);
  Fl_Menu_Button mb(0,0,WIDTH,370); mb.box(0); mb.menu(menutable);
  window.add(mb);
  Fl_Box b(200,200,200,100,"Press right button\nfor a pop-up menu");
  window.add(b);
  window.resizable(&mb);
  window.show(argc, argv);
  for (;;) Fl::wait();
}
