// test of Fl::event_shift flags:

// Note: the shift keys will not seem to do what is expected, due to
// two bugs:
//	1.I do not pay attention to key-release events, so it does not
//	notice when the shift keys are released
//	2.X insists on reporting the state *before* the shift key was
//	pressed, rather than after, on shift key events.  I fixed this
//	for the mouse buttons, but it did not seem worth it for shift.

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Output.H>
#include <stdio.h>

int main(int argc, char** argv) {
  Fl_Window window(150,8*20);
  window.begin();
  int y = 0;
  Fl_Toggle_Button bshift(0,y,100,20,"shift"); bshift.deactivate(); y += 20;
  Fl_Toggle_Button bctrl(0,y,100,20,"ctrl"); bctrl.deactivate(); y += 20;
  Fl_Toggle_Button balt(0,y,100,20,"alt"); balt.deactivate(); y += 20;
  Fl_Toggle_Button b1(0,y,100,20,"button 1"); b1.deactivate(); y += 20;
  Fl_Toggle_Button b2(0,y,100,20,"button 2"); b2.deactivate(); y += 20;
  Fl_Toggle_Button b3(0,y,100,20,"button 3"); b3.deactivate(); y += 20;
  Fl_Output key(50,y,100,20,"key:"); y += 20;
  Fl_Output text(50,y,100,20,"text:"); y += 20;
  window.end();
  window.show(argc,argv);
  for (;;) {
    bshift.value(Fl::event_shift());
    bctrl.value(Fl::event_ctrl());
    balt.value(Fl::event_alt());
    b1.value(Fl::event_button1());
    b2.value(Fl::event_button2());
    b3.value(Fl::event_button3());
    char buf[10];
    sprintf(buf,"0x%04x",Fl::event_key()); key.value(buf);
    text.value(Fl::event_text());
    Fl::wait();
  }
}
