/* 	Test input fields	*/

#include <stdio.h>
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Float_Input.H>
#include <FL/Fl_Int_Input.H>
#include <FL/Fl_Secret_Input.H>
#include <FL/Fl_Multiline_Input.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Toggle_Button.H>

void cb(Fl_Object *ob) {
  printf("Callback for %s\n",ob->label());
}

int when = 0;
Fl_Input *ia,*ib,*ic,*id,*ie;

void toggle_cb(Fl_Object *o, long v) {
  if (((Fl_Toggle_Button*)o)->value()) when |= v; else when &= ~v;
  ia->when(when);
  ib->when(when);
  ic->when(when);
  id->when(when);
  ie->when(when);
}

void test(Fl_Input *i) {
  if (i->changed()) {i->clear_changed(); printf("%s\n",i->label());}
}

void button_cb(Fl_Object *,void *) {
  test(ia);
  test(ib);
  test(ic);
  test(id);
  test(ie);
}

int main(int argc, char **argv) {
  Fl_Window *window = new Fl_Window(400,400);
  window->begin();

  int y = 10;
  ia = new Fl_Input(70,y,300,30,"Normal:");
  ia->when(0); ia->callback(cb); y += 35;
  ib = new Fl_Float_Input(70,y,300,30,"Float:");
  ib->when(0); ib->callback(cb); y += 35;
  ic = new Fl_Int_Input(70,y,300,30,"Int:");
  ic->when(0); ic->callback(cb); y += 35;
  id = new Fl_Secret_Input(70,y,300,30,"Secret:");
  id->when(0); id->callback(cb); y += 35;
  ie = new Fl_Multiline_Input(70,y,300,100,"Multiline:");
  ie->when(0); ie->callback(cb); y += 105;

  Fl_Button *b;
  b = new Fl_Toggle_Button(10,y,200,25,"FL_WHEN_&CHANGED");
  b->callback(toggle_cb, FL_WHEN_CHANGED); y += 25;
  b = new Fl_Toggle_Button(10,y,200,25,"FL_WHEN_&RELEASE");
  b->callback(toggle_cb, FL_WHEN_RELEASE); y += 25;
  b = new Fl_Toggle_Button(10,y,200,25,"FL_WHEN_&ENTER_KEY");
  b->callback(toggle_cb, FL_WHEN_ENTER_KEY); y += 25;
  b = new Fl_Toggle_Button(10,y,200,25,"FL_WHEN_&NOT_CHANGED");
  b->callback(toggle_cb, FL_WHEN_NOT_CHANGED); y += 25;
  y += 5;
  b = new Fl_Button(10,y,200,25,"&print changed()");
  b->callback(button_cb);

  window->end();
  window->show(argc,argv);
  for (;;) Fl::wait();
}
