// Fl_Window::iconize() test

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Box.H>
#include <stdlib.h>

void iconize_cb(Fl_Object *, void *v) {
  Fl_Window *w = (Fl_Window *)v;
  w->iconize();
}

void show_cb(Fl_Object *, void *v) {
  Fl_Window *w = (Fl_Window *)v;
  w->show();
}

void atclose(Fl_Window*, void*) {
  exit(0);
}

int main(int argc, char **argv) {

  Fl_Window main(200,200);
  main.show(argc,argv);

  Fl_Window control(120,90);
  control.begin();

  Fl_Button iconize_button(0,0,120,30,"iconize()");
  iconize_button.callback(iconize_cb, &main);

  Fl_Button show_button(0,30,120,30,"show()");
  show_button.callback(show_cb, &main);

  Fl_Box box(FL_NO_BOX,0,60,120,30,"Also try running\nwith -i switch");

  control.end();
  control.show();

  Fl::set_atclose(atclose);
  for (;;) Fl::wait();
}
