/* Forms demo35 modified to use size info from Fl::font_enumerate() */

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Hold_Browser.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Box.H>
#include <stdio.h>
#include <stdlib.h>

Fl_Window *form;

Fl_Box *textobj;

Fl_Hold_Browser *fontobj, *sizeobj;

int *sizes[1000];
int numsizes[1000];
int pickedsize = 14;

void font_cb(Fl_Object *, long) {
  int fn = fontobj->value();
  if (!fn) return;
  Fl::set_font(31,fontobj->text(fn));
  sizeobj->clear();
  int n = numsizes[fn-1];
  int *s = sizes[fn-1];
  if (!n) {
    // no sizes
  } else if (s[0] == 0) {
    // many sizes;
    int j = 1;
    for (int i = 1; i<64 || i<s[n-1]; i++) {
      char buf[20];
      if (j < n && i==s[j]) {sprintf(buf,"@b%d",i); j++;}
      else sprintf(buf,"%d",i);
      sizeobj->add(buf);
    }
    sizeobj->value(pickedsize);
  } else {
    // some sizes
    int w = 0;
    for (int i = 0; i < n; i++) {
      if (s[i]<=pickedsize) w = i;
      char buf[20];
      sprintf(buf,"@b%d",s[i]);
      sizeobj->add(buf);
    }
    sizeobj->value(w+1);
  }
  textobj->redraw();
}

void size_cb(Fl_Object *, long) {
  int i = sizeobj->value();
  if (!i) return;
  const char *c = sizeobj->text(i);
  while (*c < '0' || *c > '9') c++;
  pickedsize = atoi(c);
  textobj->labelsize(pickedsize);
  textobj->redraw();
}

void create_the_forms() {
  form = new Fl_Window(550,370);
  form->begin();
  textobj = new Fl_Box(FL_FRAME_BOX,10,10,530,170,"The quick brown\nfox jumps over\nthe lazy dog.");
  textobj->color(9,47);
  fontobj = new Fl_Hold_Browser(10, 190, 390, 170);
  fontobj->box(FL_FRAME_BOX);
  fontobj->color(53,3);
  fontobj->callback(font_cb);
  form->resizable(fontobj);
  sizeobj = new Fl_Hold_Browser(410, 190, 130, 170);
  sizeobj->box(FL_FRAME_BOX);
  sizeobj->color(53,3);
  sizeobj->callback(size_cb);
  form->end();
}

int num = 0;
void addit(const char *str, const int *s, int n) {
  fontobj->add(str);
  numsizes[num] = n;
  if (n) {
    sizes[num] = new int[n];
    for (int i=0; i<n; i++) sizes[num][i] = s[i];
  }
  num++;
}

int main(int argc, char **argv) {
  create_the_forms();
  textobj->labelfont(31);
  Fl::font_enumerate(addit);
  fontobj->value(1);
  font_cb(fontobj,0);
  form->show(argc,argv);
  for (;;) Fl::wait();
}
