// Double-buffering test.

// This demo shows how double buffering helps, by drawing the
// window in a particularily bad way.

// The single-buffered window will blink as it updates.  The
// double buffered one will not.  It will take just as long
// (or longer) to update, but often it will appear to be faster.

// This demo should work for both the GL and X versions of Fl,
// even though the double buffering mechanism is totally different.

#include <FL/Fl.H>
#include <FL/Fl_Single_Window.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/fl_draw.H>
#include <stdlib.h>

void bad_draw(int w,int h) {
  fl_font(1,54);
  for (int i=0; i<10; i++) {
    fl_color(7); fl_rectf(0,0,w,h); fl_color(0); fl_draw("BLINK!",10,h/2);
    fl_color(0); fl_rectf(0,0,w,h); fl_color(7); fl_draw("BLINK!",10,h/2);
  }
}

class single_blink_window : public Fl_Single_Window {
  void draw() {bad_draw(w(),h());}
public:
  single_blink_window(int w,int h,const char *l)
    : Fl_Single_Window(w,h,l) {resizable(this);}
};

class double_blink_window : public Fl_Double_Window {
  void draw() {bad_draw(w(),h());}
public:
  double_blink_window(int w,int h,const char *l)
    : Fl_Double_Window(w,h,l) {resizable(this);}
};

int main() {
  Fl::visual(FL_DOUBLE);
  single_blink_window w1(400,400,"Fl_Single_Window");
  double_blink_window w2(400,400,"Fl_Double_Window");
  w1.show();	
  w2.show();
  while (1) Fl::wait();
}
