// cursor.C

// Test the cursor setting code

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Hor_Value_Slider.H>
#include <FL/fl_draw.H>

uchar fg = 0;
uchar bg = 7;
uchar cursor = 0;

void setcursor(Fl_Object *o, void *v) {
  Fl_Hor_Value_Slider *slider = (Fl_Hor_Value_Slider *)o;
  cursor = uchar(slider->value());
  ((Fl_Window *)v)->make_current();
  fl_cursor(cursor,fg,bg);
}

void setfg(Fl_Object *o, void *v) {
  Fl_Hor_Value_Slider *slider = (Fl_Hor_Value_Slider *)o;
  fg = uchar(slider->value());
  ((Fl_Window *)v)->make_current();
  fl_cursor(cursor,fg,bg);
}

void setbg(Fl_Object *o, void *v) {
  Fl_Hor_Value_Slider *slider = (Fl_Hor_Value_Slider *)o;
  bg = uchar(slider->value());
  ((Fl_Window *)v)->make_current();
  fl_cursor(cursor,fg,bg);
}

int main(int argc, char **argv) {
  Fl_Window window(400,300);
  window.resizable(window);

  Fl_Hor_Value_Slider slider1(80,180,310,30,"Cursor:");
  slider1.align(FL_ALIGN_LEFT);
  slider1.step(1);
  slider1.precision(0);
  slider1.bounds(0,100);
  slider1.value(0);
  slider1.callback(setcursor, &window);
  slider1.value(cursor);
  window.add(slider1);

  Fl_Hor_Value_Slider slider2(80,220,310,30,"fgcolor:");
  slider2.align(FL_ALIGN_LEFT);
  slider2.step(1);
  slider2.precision(0);
  slider2.bounds(0,255);
  slider2.value(0);
  slider2.callback(setfg, &window);
  slider2.value(fg);
  window.add(slider2);

  Fl_Hor_Value_Slider slider3(80,260,310,30,"bgcolor:");
  slider3.align(FL_ALIGN_LEFT);
  slider3.step(1);
  slider3.precision(0);
  slider3.bounds(0,255);
  slider3.value(0);
  slider3.callback(setbg, &window);
  slider3.value(bg);
  window.add(slider3);

  window.show(argc,argv);
  while (1) Fl::wait();
}
