/* 	Test the adjuster	*/

#include <stdlib.h>
#include <stdio.h>
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Adjuster.H>
#include <FL/Fl_Box.H>

void adjcb(Fl_Object *o, void *v) {
    Fl_Adjuster *a = (Fl_Adjuster*)o;
    Fl_Box *b = (Fl_Box *)v;
    sprintf((char *)(b->label()),"%g",a->value());
    b->redraw();
}

int main(int, char ** argv) {
   Fl_Window window(320,100,argv[0]);

   char buf1[100];
   Fl_Box b1(FL_DOWN_BOX,20,30,80,25,buf1);
   b1.color(FL_WHITE);
   Fl_Adjuster a1(20+80,30,3*25,25);
   a1.callback(adjcb,&b1);
   adjcb(&a1,&b1);

   char buf2[100];
   Fl_Box b2(FL_DOWN_BOX,20+80+4*25,30,80,25,buf2);
   b2.color(FL_WHITE);
   Fl_Adjuster a2(b2.x()+b2.w(),10,25,3*25);
   a2.callback(adjcb,&b2);
   adjcb(&a2,&b2);

   window.add(b1);
   window.add(a1);
   window.add(b2);
   window.add(a2);
   window.resizable(window);
   window.show();
   while (1) Fl::wait();
}
