/* Copyright (C) 1992, 1993, 1994, 1995, 1996 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <config.h>
#include <ctype.h>
#include <stdlib.h>
#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#ifdef SVR4

#include <stdlib.h>
#include <string.h>
#include <errno.h>

int
scandir (const char *dir, struct dirent ***namelist,
	 int (*select)(const struct dirent *),
	 int (*compar)(const struct dirent **, const struct dirent **))
{
  DIR *dp = opendir (dir);
  struct dirent **v = NULL;
  size_t vsize = 0, i;
  struct dirent *d;
  int save;

  if (dp == NULL)
    return -1;

  save = errno;
  errno = 0;

  i = 0;
  while ((d = readdir (dp)) != NULL)
    if (select == NULL || (*select) (d))
      {
      size_t dsize;

      if (i == vsize)
        {
          struct dirent **new;
          if (vsize == 0)
            vsize = 10;
          else
            vsize *= 2;
          new = (struct dirent **) realloc (v, vsize * sizeof (*v));
          if (new == NULL)
            {
            lose:
              errno = ENOMEM;
              break;
            }
          v = new;
        }

#define _D_EXACT_NAMLEN(d) (strlen ((d)->d_name))
#define _D_ALLOC_NAMLEN(d) (sizeof (d)->d_name > 1 ? sizeof (d)->d_name : \
                              _D_EXACT_NAMLEN (d) + 1)

      dsize = &d->d_name[_D_ALLOC_NAMLEN (d)] - (char *) d;
      v[i] = (struct dirent *) malloc (dsize);
      if (v[i] == NULL)
        goto lose;

      memcpy (v[i++], d, dsize);
      }

  if (errno != 0)
    {
      save = errno;
      (void) closedir (dp);
      while (i > 0)
      free (v[--i]);
      free (v);
      errno = save;
      return -1;
    }

  (void) closedir (dp);
  errno = save;

  /* Sort the list if we have a comparison function to sort with.  */
  if (cmp != NULL)
    qsort (v, i, sizeof (*v), cmp);
  *namelist = v;
  return i;
}

int alphasort (struct dirent **a, struct dirent **b) {
  return strcmp ((*a)->d_name, (*b)->d_name);
}

#endif

/* My own sorting function, useful for the film industry where we have
   many files with numbers in their names: */

int numericcmp(const char *a, const char *b) {
  int nreturn = 0;
  for (;;) {
    if (isdigit(*a) && isdigit(*b)) {
      int na = strtol(a, (char **)&a, 10);
      int nb = strtol(b, (char **)&b, 10);
      if (!nreturn) nreturn = na-nb;
    } else if (*a == *b) {
      if (!*a) return nreturn;
      a++; b++;
    } else
      return (*a-*b);
  }
}

int numericsort(struct dirent **a, struct dirent **b) {
  return numericcmp((*a)->d_name, (*b)->d_name);
}
