// Code to switch current FL drawing context in/out of GL "mode":

// You MUST use gl_visual() to select the default visual before doing
// show() of any windows.  Some versions of GL will crash if the visual
// is not one of the supported ones.

// This does not work with Fl_Double_Window's!  It crashes if pixmaps
// are being used.  If Xdbe is being used it sort of works, but there
// are mysterious drawing errors.

#include <config.h>
#if HAVE_GL

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/x.H>
#include <FL/fl_draw.H>
#include <GL/glx.h>

#include "Fl_Gl_Choice.H"

extern GLXContext fl_first_context; // in Fl_Gl_Choice.C
extern int fl_clip_state_number; // in fl_rect.C

static GLXContext context;
static int clip_state_number;
static int pw, ph;

void gl_start() {
  if (!context) {
    context = glXCreateContext(fl_display, fl_visual, fl_first_context, 1);
    if (!context) Fl::abort("OpenGL does not support this visual");
    if (!fl_first_context) fl_first_context = context;
  }
  glXMakeCurrent(fl_display, fl_window, context);
  glXWaitX();
  if (pw != Fl_Window::current()->w() || ph != Fl_Window::current()->h()) {
    pw = Fl_Window::current()->w();
    ph = Fl_Window::current()->h();
    glLoadIdentity();
    glViewport(0, 0, pw, ph);
    glOrtho(0, pw, 0, ph, -1, 1);
  }
  if (clip_state_number != fl_clip_state_number) {
    clip_state_number = fl_clip_state_number;
    if (fl_clipped) {
      glScissor(fl_current_clip.x,
		Fl_Window::current()->h() - fl_current_clip.b,
		fl_current_clip.r - fl_current_clip.x,
		fl_current_clip.b - fl_current_clip.y);
      glEnable(GL_SCISSOR_TEST);
    } else {
      glDisable(GL_SCISSOR_TEST);
    }
  }    
}

void gl_finish() {
  glXWaitGL();
}

int Fl::gl_visual(int mode, int *alist) {
  Fl_Gl_Choice *c = Fl_Gl_Choice::find(mode,alist);
  if (!c) return 0;
  fl_visual = c->vis;
  fl_colormap = c->colormap;
  return 1;
}

#endif
