// gl_draw.C

// Functions from gl_draw.H
// See also Fl_Gl_Window and gl_start.C

#include <config.h>
#if HAVE_GL

#include <FL/Fl.H>
#include <FL/gl_draw.H>
#include <GL/glx.h>
#include "Fl_Font.H"
#include <string.h>

// stuff from fl_draw.H:
void  fl_font(uchar fontid, int size);
int   fl_height();	// using "size" should work ok
int   fl_descent();
float fl_width(const char *);
float fl_width(const char *, int n);
float fl_width(uchar);
unsigned long fl_xpixel(uchar i);

void  gl_font(uchar fontid, int size) {fl_font(fontid, size);}
int   gl_height() {return fl_height();}
int   gl_descent() {return fl_descent();}
float gl_width(const char *s) {return fl_width(s);}
float gl_width(const char *s, int n) {return fl_width(s,n);}
float gl_width(uchar c) {return fl_width(c);}

void gl_draw(const char *str, int n) {
  if (!fl_current_font->madelistbase) {
    int base = fl_current_font->font->min_char_or_byte2;
    int size = fl_current_font->font->max_char_or_byte2-base+1;
//  int base = 0; int size = 256;
    fl_current_font->listbase = glGenLists(size)-base;
    glXUseXFont(fl_current_font->font->fid, base, size, 
		fl_current_font->listbase+base);
    fl_current_font->madelistbase = 1;
  }
  glListBase(fl_current_font->listbase);
  glCallLists(n, GL_UNSIGNED_BYTE, str);
}

void gl_draw(const char *str, int n, int x, int y) {
  glRasterPos2i(x, y);
  gl_draw(str, n);
}

void gl_draw(const char *str) {
  gl_draw(str, strlen(str));
}

void gl_draw(const char *str, int x, int y) {
  gl_draw(str, strlen(str), x, y);
}

static void gl_draw_invert(const char *str, int n, int x, int y) {
  glRasterPos2i(x, -y);
  gl_draw(str, n);
}

void gl_draw(
  const char *str, 	// the (multi-line) string
  int x, int y, int w, int h, 	// bounding box
  uchar align) {
  fl_draw(str, x, -y-h, w, h, align, gl_draw_invert);
}

void gl_rect(int x, int y, int w, int h) {
  if (w < 0) {w = -w; x = x-w;}
  if (h < 0) {h = -h; y = y-h;}
  glBegin(GL_LINE_STRIP);
  glVertex2i(x+w-1, y+h);
  glVertex2i(x+w-1, y);
  glVertex2i(x, y);
  glVertex2i(x, y+h-1);
  glVertex2i(x+w-1, y+h-1);
  glEnd();
}

extern uchar fl_rgbmode;

void gl_color(uchar i) {
  if (!fl_rgbmode) {
    glIndexi(fl_xpixel(i));
  } else {
    uchar red, green, blue;
    Fl::get_color(i, red, green, blue);
    glColor3ub(red, green, blue);
  }
}
  
// void gl_mult_matrix(float a, float b, float c, float d, float x, float y) {
//   float m[16];
//   m[0] = a; m[1] = b; m[2] = 0; m[3] = 0;
//   m[4] = c; m[5] = d; m[6] = 0; m[7] = 0;
//   m[8] = 0; m[9] = 0; m[10]= 1; m[11]= 0;
//   m[12]= x; m[13]= y; m[14]= 0; m[15]= 1;
//   glMultMatrixf(m);
// }

void gl_draw_image(const uchar *b, int x, int y, int w, int h, int d, int ld) {
  if (!ld) ld = w*d;
  glPixelStorei(GL_UNPACK_ROW_LENGTH, ld/d);
  glRasterPos2i(x,y);
  glDrawPixels(w,h,d<4?GL_RGB:GL_RGBA,GL_UNSIGNED_BYTE,(const ulong *)b);
}

#endif

