// gl_arc.C

// Utility for drawing arcs in OpenGL, adding them to current path
// Current implementation produces a 16-sided polygon.
// That's pretty lame.  This should use GL evaluators.

#include <config.h>
#if HAVE_GL

#include <FL/gl_draw.H>
#include <GL/gl.h>

#define RN	4
static float offset[RN+1] = {
  0.5, 0.382683/2+.5, 0.707106/2+.5, 0.923879/2+.5, 1.0
};

void gl_arc(float x,float y,float w,float h,int start,int end) {
  float v[2];
  start = (start*RN/90)%(RN*4);
  end = (end*RN/90)%(RN*4);
  for (int i = start; ; i = (i+1)%(RN*4)) {
    int j = i/RN;
    int k = i%RN;
    if (j&1) {
      if (j&2) {
	v[0] = offset[k]; v[1] = 1-offset[RN-k];
      } else {
	v[0] = 1-offset[k]; v[1] = offset[RN-k];
      }
    } else {
      if (j&2) {
	v[0] = 1-offset[RN-k]; v[1] = 1-offset[k];
      } else {
	v[0] = offset[RN-k]; v[1] = offset[k];
      }
    }
    glVertex2f(v[0]*w+x, v[1]*h+y);
    if (i == end) break;
  }
}

void gl_arc(float x,float y,float r,int start,int end) {
  gl_arc(x-r,y-r,2*r,2*r,start,end);
}

void gl_circle(float x,float y,float w,float h) {
  int k;
  for (k = 0; k<RN; k++)
    glVertex2f(offset[RN-k]*w+x, offset[k]*h+y);
  for (k = 0; k<RN; k++)
    glVertex2f((1-offset[k])*w+x, offset[RN-k]*h+y);
  for (k = 0; k<RN; k++)
    glVertex2f((1-offset[RN-k])*w+x, (1-offset[k])*h+y);
  for (k = 0; k<RN; k++)
    glVertex2f(offset[k]*w+x, (1-offset[RN-k])*h+y);
}

void gl_circle(float x,float y,float r) {
  gl_circle(x-r,y-r,2*r,2*r);
}

#endif
