// forms_bitmap.C
// Forms compatability object to draw a bitmap

#include <FL/forms.H>

Fl_FormsBitmap::Fl_FormsBitmap(uchar t,int x,int y,int w,int h,const char*l)
: Fl_Object(x,y,w,h,l) {
  box(t);
  b = 0;
  color(0);
  align(FL_ALIGN_BOTTOM);
}

void Fl_FormsBitmap::set(int W, int H, const uchar *bits) {
  delete b;
  bitmap(new Fl_Bitmap(bits,W,H));
}

void Fl_FormsBitmap::draw() {
  draw_box(box(),color2());
  if (b) {fl_color(color()); fl_draw(b,x(),y(),w(),h());}
  draw_label();
}
