// forms.C

// Forms library compatability functions.
// Many more functions are defined as inlines in forms.h!

#include <FL/forms.H>
#include <stdio.h>

char fl_flip = 2;
void fl_end_form() {
  if (fl_flip) Fl_Group::current()->flip();
  Fl_Group::current(0);
}
void fl_end_group() {
  Fl_Group::current()->resize(); // must be before flip
  if (fl_flip) Fl_Group::current()->flip();
  Fl_Group::current()->end();
}

static int initargc;
static char **initargv;

void fl_initialize(int *argc, char **argv, const char *, FL_CMD_OPT *, int) {
  initargc = *argc;
  initargv = new char*[*argc+1];
  int i,j;
  for (i=0; i<=*argc; i++) initargv[i] = argv[i];
  for (i=j=1; i<*argc; ) {
    if (Fl::arg(*argc,argv,i));
    else argv[j++] = argv[i++];
  }
  argv[j] = 0;
  *argc = j;
  if (fl_flip==2) fl_flip = 0;
}

char fl_modal_next; // set by fl_freeze_forms()

void fl_show_form(Fl_Window *f,int place,int b,const char *n) {

  Fl::enable_symbols();

  f->label(n);
  if (!b) f->clear_border();
  if (fl_modal_next || b==FL_TRANSIENT) {f->set_modal(); fl_modal_next = 0;}

  if (place & FL_PLACE_MOUSE) f->hotspot(f);

  if (place & FL_PLACE_CENTER)
    f->position((Fl::w()-f->w())/2, (Fl::h()-f->h())/2);

  if (place & FL_PLACE_FULLSCREEN)
    f->fullscreen();

  if (place & (FL_PLACE_POSITION | FL_PLACE_GEOMETRY))
    f->position(
      (f->x() < 0) ? Fl::w()-f->w()+f->x()-1 : f->x(),
      (f->y() < 0) ? Fl::h()-f->h()+f->y()-1 : f->y());

// if (place & FL_PLACE_ASPECT) {
// this is not yet implemented
// it can be done by setting this after the show().
//  XSizeHints hints;
//	hints.flags |= PAspect;
//	hints.min_aspect.x = hints.max_aspect.x = W;
//	hints.min_aspect.y = hints.max_aspect.y = H;
//  XSetWMNormalHints(Fl::display, xid_, &hints);
// }

  if (place == FL_PLACE_FREE || place == FL_PLACE_SIZE)
    f->free_position();

  if (place == FL_PLACE_FREE || place & FL_FREE_SIZE)
    if (!f->resizable()) f->resizable(f);

  if (initargc) {f->show(initargc,initargv); initargc = 0;}
  else f->show();
}

Fl_Object *fl_do_forms(void) {
  Fl_Object *obj;
  while (!(obj = Fl::readqueue())) Fl::wait();
  return obj;
}

Fl_Object *fl_check_forms() {
    Fl::check();
    return Fl::readqueue();
}

void fl_set_graphics_mode(int /*r*/,int /*d*/) {}

void Fl_FormsText::draw() {
    draw_box();
    align(align()|FL_ALIGN_INSIDE); // questionable method of compatability
    draw_label();
}

// this should be moved to another source file, since it links stdio?
int Fl_Browser::load(const char *filename) {
#define MAXFL_BLINE 1024
    char newtext[MAXFL_BLINE];
    int c;
    int i;
    clear();
    if (!filename || !(filename[0])) return 1;
    FILE *fl = fopen(filename,"r");
    if (!fl) return 0;
    i = 0;
    do {
	c = getc(fl);
	if (c == '\n' || c <= 0 || i>=MAXFL_BLINE-1) {
	    newtext[i] = 0;
	    add(newtext);
	    i = 0;
	} else
	    newtext[i++] = c;
    } while (c >= 0);
    fclose(fl);
    return 1;
}

// Create a forms button by selecting correct FL subclass:

#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Repeat_Button.H>

Fl_Button *fl_add_button(uchar t,int x,int y,int w,int h,const char *l) {
  Fl_Button *b;
  switch (t) {
  case FL_RETURN_BUTTON:
  case FL_HIDDEN_RET_BUTTON:
    b = new Fl_Return_Button(x,y,w,h,l);
    break;
  case FL_TOUCH_BUTTON:
    b = new Fl_Repeat_Button(x,y,w,h,l);
    break;
  default:
    b = new Fl_Button(x,y,w,h,l);
  }
  switch (t) {
  case FL_TOGGLE_BUTTON:
  case FL_RADIO_BUTTON:
    b->type(t);
    break;
  case FL_HIDDEN_BUTTON:
  case FL_HIDDEN_RET_BUTTON:
    b->type(FL_HIDDEN_BUTTON);
    break;
  case FL_INOUT_BUTTON:
    b->when(FL_WHEN_CHANGED);
    break;
  }
  return b;
}
