// fl_vertex.C

// Portable drawing code for drawing arbitrary shapes with
// simple 2D transformations.  See also fl_arc.C

#include <FL/fl_draw.H>
#include <FL/x.H>
#include <math.h>
#include <stdlib.h>

struct matrix {float a, b, c, d, x, y;};

static matrix m = {1, 0, 0, 1, 0, 0};

static matrix stack[10];
static int sptr = 0;

void fl_push_matrix() {stack[sptr++] = m;}

void fl_pop_matrix() {m = stack[--sptr];}

void fl_mult_matrix(float a, float b, float c, float d, float x, float y) {
  matrix o;
  o.a = a*m.a + b*m.c;
  o.b = a*m.b + b*m.d;
  o.c = c*m.a + d*m.c;
  o.d = c*m.b + d*m.d;
  o.x = x*m.a + y*m.c + m.x;
  o.y = x*m.b + y*m.d + m.y;
  m = o;
}

void fl_scale(float x,float y) {fl_mult_matrix(x,0,0,y,0,0);}

void fl_scale(float x) {fl_mult_matrix(x,0,0,x,0,0);}

void fl_translate(float x,float y) {fl_mult_matrix(1,0,0,1,x,y);}

void fl_rotate(float d) {
  float s = sin(d*M_PI/180);
  float c = cos(d*M_PI/180);
  fl_mult_matrix(c,-s,s,c,0,0);
}

static XPoint *p;
static int p_size;
static int n;
static int what;
enum {LINE, LOOP, POLYGON};

void fl_begin_line() {n = 0; what = LINE;}

void fl_begin_loop() {n = 0; what = LOOP;}

void fl_begin_polygon() {n = 0; what = POLYGON;}

float fl_transform_x(float x, float y) {
  return x*m.a + y*m.c + m.x;
}

float fl_transform_y(float x, float y) {
  return x*m.b + y*m.d + m.y;
}

void fl_transformed_vertex(float xf, float yf) {
  short x = short(xf+.5);
  short y = short(yf+.5);
  if (!n || x != p[n-1].x || y != p[n-1].y) {
    if (n >= p_size) {
      p_size = p ? 2*p_size : 16;
      p = (XPoint *)realloc((void*)p, p_size*sizeof(*p));
    }
    p[n].x = x;
    p[n].y = y;
    n++;
  }
}

void fl_vertex(float x,float y) {
  fl_transformed_vertex(x*m.a + y*m.c + m.x, x*m.b + y*m.d + m.y);
}

void fl_vertex(const float *p) {fl_vertex(p[0],p[1]);}

void fl_end() {
  if (!n);
  else if (what == POLYGON)
    XFillPolygon(fl_display, fl_window, fl_gc, p, n, Convex, 0);
  else {
    if (what == LOOP) {p[n] = p[0]; n++;}
    XDrawLines(fl_display, fl_window, fl_gc, p, n, 0);
  }
}

// shortcut the closed circles so they use XDrawArc:
// warning: these do not draw rotated ellipses correctly!
// See fl_arc.c for portable version.

void fl_circle(float x,float y,float w,float h) {
  float scale = m.c ? sqrt(m.a*m.a+m.c*m.c) : fabs(m.a);
  int wt = int(w*scale + .5);
  scale = m.b ? sqrt(m.b*m.b+m.d*m.d) : fabs(m.d);
  int ht = int(h*scale + .5);
  float cx = x+w/2;
  float cy = y+h/2;
  int xt = int(cx*m.a + cy*m.c + m.x - wt/2.0 + .5);
  int yt = int(cx*m.b + cy*m.d + m.y - ht/2.0 + .5);
  (what == POLYGON ? XFillArc : XDrawArc)
    (fl_display, fl_window, fl_gc, xt, yt, wt, ht, 0, 360*64);
}

void fl_circle(float x,float y,float r) {
  fl_circle(x-r,y-r,2*r,2*r);
}
