// fl_show_colormap.C

// Select a color from the colormap.
// Pretty much unchanged from Forms.

#include <FL/fl_show_colormap.H>

#include <FL/Fl.H>
#include <FL/Fl_Single_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>
#include <FL/fl_draw.H>

static Fl_Window *colorform;
static Fl_Button *col[64];
static Fl_Button *prev, *next, *cancel;

static void create_colorform(void) {
  int i1,i,j;
  if (colorform) return;
  colorform = new Fl_Single_Window(240, 220, 0); colorform->box(FL_UP_BOX);
  colorform->clear_border();
  colorform->set_modal();
  for (i1=0; i1<8; i1++) for (j=0; j<8; j++) {
    i = i1;
    // create buttons in a checkerboard so colors are allocated evenly:
    // if (i1>=4) {i = (i1-4)*2; if (j&1) i++;}
    // else {i = i1*2; if (!(j&1)) i++;}
    Fl_Button *b = new Fl_Button(40+j*20,10+i*20,20,20,0);
    b->box(FL_BORDER_BOX);
    b->down_box(FL_DOWN_BOX);
    b->labelcolor(7);
    b->labeltype(FL_SYMBOL_LABEL);
    b->argument(i*8+j);
    col[i*8+j] = b;
    colorform->add(b);
  }
  prev = new Fl_Button(10, 10, 30, 160,"@4"); prev->labeltype(FL_SYMBOL_LABEL);
  next = new Fl_Button(200,10, 30, 160,"@6"); next->labeltype(FL_SYMBOL_LABEL);
  cancel = new Fl_Button(40,180,160, 30, "Cancel");
  colorform->add(prev);
  colorform->add(next);
  colorform->add(cancel);
}

static void init_colors(int cc, int thecol) {
  for (int i=0; i<64; i++) {
    col[i]->color(cc+i,cc+i);
    col[i]->label(thecol==cc+i ? "@+19plus" : 0);
//  col[i]->value(thecol==cc+i);
  }
  colorform->redraw();
}

int fl_show_colormap(int oldcol) {
  Fl_Object *ob;
  int cc = 64 * (oldcol/64), thecol =oldcol;
  create_colorform();
  init_colors(cc,thecol);
  cancel->color(thecol,thecol);

  while (Fl::readqueue()); // clear the queue

  colorform->hotspot(colorform);
  colorform->show();
  for (;;) {
    ob = Fl::readqueue();
    if (!ob) Fl::wait();
    else if (ob == prev) {if (cc>0) {cc -= 64; init_colors(cc,thecol);}}
    else if (ob == next) {if (cc<256-64) {cc+=64; init_colors(cc,thecol);}}
    else if (ob == cancel || ob == colorform) break;
    else {thecol = ob->argument()+cc; break;}
  }
  colorform->hide();
  return thecol;
}
