// fl_shortcut.C

// Code to test and parse FL shortcut strings.

// Shortcut strings are somewhat compatable with Forms.
// They consist of any number of the following, concatenated:
// Prefix codes must be in this order:
//	# = hold down alt
//	+ = hold down shift (only for F keys)
//	^ = hold down control
// Followed by:
//	<ascii> type that key on main keyboard
//	Fn = that function key (n is all following digits)
//	^?,^@,^A-Z,^[,^\,^],^^,^_ match any key producing ^X
// The only way to quote #, +, ^ is to put them last in the string
// No way to distingush Return from ^M, although it does not match ^m,
// similar problem for Tab, Backspace, Escape.
// Currently no way to shortcut arrows, keypad, or other keys

#include <FL/Fl.H>
#include <FL/Fl_Object.H>
#include <ctype.h>
#include <string.h>

int Fl::test_shortcut(const char *s) {
  if (!s) return 0;
  while (*s) {
    char code = *s++;
    int alt; if (code == '#' && *s) {alt = 1; code = *s++;} else alt = 0;
    int shift;if (code == '+' && *s) {shift=1; code = *s++;} else shift = 0;
    int ctrl; if (code == '^' && *s) {ctrl = 1; code = *s++;} else ctrl = 0;
    if (code == 'F' && isdigit(*s)) {
      int n = (*s++)-'0'; while (isdigit(*s)) n = 10*n+(*s++)-'0';
      if (event_key() == FL_F+n &&
	  (event_shift()!=0)==shift &&
	  (event_ctrl()!=0)==ctrl &&
	  (event_alt()!=0)==alt) return 1;
    } else if (event_key() == code || event_text()[0] == code) {
      if ((event_ctrl()!=0)==ctrl &&
	  (event_alt()!=0)==alt) return 1;
    } else if (ctrl && code >= 0x3f && code <= 0x5F) {
      if (event_text()[0]==(code ^ 0x40) &&
	  (event_alt()!=0)==alt) return 1;
    }
  }
  return 0;
}

const char * fl_shortcut_label(const char *s) {
  static char buf[20];
  char *p = buf;
  if (!s || !*s) {*p = 0; return buf;}
  char code = *s++;
  if (code == '#' && *s) {code = *s++; strcpy(p,"Alt+"); p += 4;}
  if (code == '+' && *s) {code = *s++; strcpy(p,"Shift+"); p += 6;}
  if (code == '^' && *s) {code = *s++; *p++ = '^';}
  if (code == 'F' && isdigit(*s)) {
    *p++ = 'F';
    do *p++ = *s++; while (isdigit(*s));
  } else 
    *p++ = code;
  *p = 0;
  return buf;
}

int Fl_Object::test_shortcut() {
//  if (!Fl::event_alt()) return 0;
  if (!(flags()&SHORTCUT_LABEL)) return 0;
  return test_shortcut(label());
}

int Fl_Object::test_shortcut(const char *s) {
  if (!s || !Fl::event_text()[0]) return 0;
  for (;;) {
    if (!*s) return 0;
    if (*s++ == '&' && *s) {
      if (*s == '&') s++;
      else if (tolower(*s) == tolower(Fl::event_text()[0]&127)) return 1;
      else return 0;
    }
  }
}
