// fl_scandir.C

// Wrapper for scandir so another program (Nuke) can override it and
// produce it's own file lists.  This is called from fl_file_chooser.

#include <config.h>
#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

// this function is in scandir.c:
extern "C" {int numericsort(struct dirent **, struct dirent **);}

// this function is also in scandir.c for machines not providing it:
#ifdef SVR4
extern "C" {
int
scandir (const char *dir, struct dirent ***namelist,
	 int (*select)(const struct dirent *),
	 int (*compar)(const struct dirent **, const struct dirent **));
}
#endif

int fl_scandir(const char *d, dirent ***list) {
#ifdef _AIX
    // on some systems you may need to do this, due to a rather common
    // error in the prototype for the sorting function:
    return scandir(d, list, 0, (int(*)(const void*,const void*))numericsort);
#else
    return scandir(d, list, 0, numericsort);
#endif
}
