/*	fl_rounded_box.C

	Less-used box types are in seperate files so they are not linked
	in if not used.

*/

#include <FL/Fl.H>
#include <FL/fl_draw.H>

#define RN	5
#define RS	15
#define BW	3

#if 1
// Portable version using fl_draw functions:

#define vv(x,y) fl_vertex(x,y)

static float offset[RN] = { 0.0, 0.07612, 0.29289, 0.61732, 1.0};

static void rbox(int fill, int x, int y, int w, int h) {
  int i;
  int rsx ,rsy, rs;
  rsx = w*2/5; rsy = h*2/5;
  if (rsx > rsy) rs = rsy; else  rs = rsx;
  if (rs > RS) rs = RS;
  rsx = rs; rsy = rs;

  if (fill) fl_begin_polygon(); else fl_begin_loop();
  for (i=0; i<RN; i++)
    vv(x + offset[RN-i-1]*rsx, y + offset[i] * rsy);
  for (i=0; i<RN; i++)
    vv(x + offset[i]*rsx, y + h-1 - offset[RN-i-1] * rsy);
  for (i=0; i<RN; i++)
    vv(x + w-1 - offset[RN-i-1]*rsx, y + h-1 - offset[i] * rsy);
  for (i=0; i<RN; i++)
    vv(x + w-1 - offset[i]*rsx, y + offset[RN-i-1] * rsy);
  fl_end();
}

#else
// use XDrawArcs.  In my opinion, this did not work as well.

#include <FL/x.H>

static void rbox(int fill, int x, int y, int w, int h) {
  int rsx ,rsy, rs;
  rsx = w*2/5; rsy = h*2/5;
  if (rsx > rsy) rs = rsy; else rs = rsx;
  if (rs > RS) rs = RS;
  rsx = rs; rsy = rs;
  XArc arcs[8];
  // my god, is X lame!
  XArc *a = arcs;
  w--; h--;

  a->x = x+w-2*rsx;
  a->y = y;
  a->width = 2*rsx;
  a->height = 2*rsy;
  a->angle1 =   0*64;
  a->angle2 =  90*64;
  a++;

  if (!fill) {
    a->x = x+rsx;
    a->y = y;
    a->width = w-2*rsx;
    a->height = 0;
    a->angle1 =   0*64;
    a->angle2 = 180*64;
    a++;
  }

  a->x = x;
  a->y = y;
  a->width = 2*rsx;
  a->height = 2*rsy;
  a->angle1 =  90*64;
  a->angle2 =  90*64;
  a++;

  if (!fill) {
    a->x = x;
    a->y = y+rsy;
    a->width = 0;
    a->height = h-2*rsy;
    a->angle1 =  90*64;
    a->angle2 = 180*64;
    a++;
  }

  a->x = x;
  a->y = y+h-2*rsy;
  a->width = 2*rsx;
  a->height = 2*rsy;
  a->angle1 = 180*64;
  a->angle2 =  90*64;
  a++;

  if (!fill) {
    a->x = x+rsx;
    a->y = y+h;
    a->width = w-2*rsx;
    a->height = 0;
    a->angle1 = 180*64;
    a->angle2 = 180*64;
    a++;
  }

  a->x = x+w-2*rsx;
  a->y = y+h-2*rsy;
  a->width = 2*rsx;
  a->height = 2*rsy;
  a->angle1 = 270*64;
  a->angle2 =  90*64;
  a++;

  if (!fill) {
    a->x = x+w;
    a->y = y+rsy;
    a->width = 0;
    a->height = h-2*rsy;
    a->angle1 = 270*64;
    a->angle2 = 180*64;
    a++;
  }

  if (fill) {
    XFillArcs(fl_display,fl_window,fl_gc,arcs,4);
    XFillRectangle(fl_display, fl_window, fl_gc, x+rsx, y, w-2*rsx, h);
    XFillRectangle(fl_display, fl_window, fl_gc, x, y+rsy, w, h-2*rsy);
  } else {
    XDrawArcs(fl_display,fl_window,fl_gc,arcs,8);
  }
}

#endif

static void fl_rflat_box(int x, int y, int w, int h, uchar c) {
  fl_color(c); rbox(1,x,y,w,h); rbox(0,x,y,w,h);
}

static void fl_rounded_frame(int x, int y, int w, int h, uchar c) {
  fl_color(c); rbox(0,x,y,w,h);
}

static void fl_rounded_box(int x, int y, int w, int h, uchar c) {
  fl_color(c); rbox(1,x,y,w,h);
  fl_color(FL_BLACK); rbox(0,x,y,w,h);
}

static void fl_rshadow_box(int x, int y, int w, int h, uchar c) {
  /* draw shadow: */
  fl_color(FL_DARK3);
  rbox(1,x+BW,y+BW,w,h);
  rbox(0,x+BW,y+BW,w,h);
  /* draw the box: */
  fl_rounded_box(x,y,w,h,c);
}

uchar define_FL_ROUNDED_BOX() {
  Fl::set_boxtype(_FL_ROUNDED_FRAME,fl_rounded_frame);
  return Fl::set_boxtype(_FL_ROUNDED_BOX,fl_rounded_box);
}

uchar define_FL_RFLAT_BOX() {
  return Fl::set_boxtype(_FL_RFLAT_BOX,fl_rflat_box);
}

uchar define_FL_RSHADOW_BOX() {
  return Fl::set_boxtype(_FL_RSHADOW_BOX,fl_rshadow_box);
}
