/*	fl_round_box.C

	Box drawing code for an obscure box type.
	These box types are in seperate files so they are not linked
	in if not used.

*/

#include <FL/Fl.H>
#include <FL/fl_draw.H>

static void ularc(int x,int y,int w,int h) {
  if (w > h) {
    fl_arc(x+w-h,y,h,h,45,90);
    fl_arc(x,y,h,h,90,225);
  } else {
    fl_arc(x,y,w,w,45,180);
    fl_arc(x,y+h-w,w,w,180,225);
  }
}

static void lrarc(int x,int y,int w,int h) {
  if (w > h) {
    fl_arc(x,y,h,h,225,270);
    fl_arc(x+w-h,y,h,h,270,45);
  } else {
    fl_arc(x,y+h-w,w,w,225,0);
    fl_arc(x,y,w,w,0,45);
  }
}

static void fl_round_down_box(int x,int y,int w,int h,uchar bgcolor) {
  w--; h--;
  fl_color(FL_LIGHT3); fl_begin_polygon(); lrarc(x,y,w,h); fl_end();
  fl_color(FL_DARK3); fl_begin_polygon(); ularc(x,y,w,h); fl_end();
  fl_color(bgcolor);
  fl_begin_polygon();
  ularc(x+3,y+3,w-6,h-6);
  lrarc(x+3,y+3,w-6,h-6);
  fl_end();
  fl_color(FL_DARK2); fl_begin_line(); ularc(x,y,w,h); fl_end();
  fl_color(FL_LIGHT2); fl_begin_line(); lrarc(x,y,w,h); fl_end();
  fl_color(FL_GRAY0);
  fl_begin_loop(); 
  ularc(x+3,y+3,w-6,h-6);
  lrarc(x+3,y+3,w-6,h-6);
  fl_end();
}

static void fl_round_up_box(int x,int y,int w,int h,uchar bgcolor) {
  w--; h--;
  fl_color(FL_LIGHT3); fl_begin_polygon(); ularc(x,y,w,h); fl_end();
  fl_color(FL_DARK3); fl_begin_polygon(); lrarc(x,y,w,h); fl_end();
  fl_color(bgcolor);
  fl_begin_polygon();
  ularc(x+3,y+3,w-6,h-6);
  lrarc(x+3,y+3,w-6,h-6);
  fl_end();
  fl_color(FL_LIGHT2); fl_begin_line(); ularc(x+3,y+3,w-6,h-6); fl_end();
  fl_color(FL_DARK2); fl_begin_line(); lrarc(x+3,y+3,w-6,h-6); fl_end();
  fl_color(FL_GRAY0);
  fl_begin_loop(); 
  ularc(x,y,w,h);
  lrarc(x,y,w,h);
  fl_end();
}

uchar define_FL_ROUND_UP_BOX() {
  Fl::set_boxtype(_FL_ROUND_DOWN_BOX,fl_round_down_box);
  return Fl::set_boxtype(_FL_ROUND_UP_BOX,fl_round_up_box);
}
