// fl_rgbcolor.C

// Implementation of fl_color(r,g,b)

// On X this means finding out the true color visual pixel layout.

// If this is not a truecolor visual then we pick the nearest color
// in the FL color cube, and get the pixel for that.  This means a
// double approximation and the result is really not very good.

#include <config.h>
#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <FL/x.H>

static int visual_id;	// which visual we calculated for (so it can change)

uchar fl_redmask, fl_greenmask, fl_bluemask;
int fl_redshift, fl_greenshift, fl_blueshift, fl_extrashift;

static void figure_out_visual() {
  visual_id = fl_visual->visual->visualid;
  if (!fl_visual->red_mask || !fl_visual->green_mask || !fl_visual->blue_mask){
#if HAVE_XCOLORMAP
    fl_redmask = 0;
    return;
#else
    Fl::abort("Requires true color visual");
#endif
  }

  // get the bit masks into a more useful form:
  int i,j,m;

  for (i = 0, m = 1; m; i++, m<<=1) if (fl_visual->red_mask & m) break;
  for (j = i; m; j++, m<<=1) if (!(fl_visual->red_mask & m)) break;
  fl_redshift = j-8;
  fl_redmask = (j-i >= 8) ? 0xFF : 0xFF-(255>>(j-i));

  for (i = 0, m = 1; m; i++, m<<=1) if (fl_visual->green_mask & m) break;
  for (j = i; m; j++, m<<=1) if (!(fl_visual->green_mask & m)) break;
  fl_greenshift = j-8;
  fl_greenmask = (j-i >= 8) ? 0xFF : 0xFF-(255>>(j-i));

  for (i = 0, m = 1; m; i++, m<<=1) if (fl_visual->blue_mask & m) break;
  for (j = i; m; j++, m<<=1) if (!(fl_visual->blue_mask & m)) break;
  fl_blueshift = j-8;
  fl_bluemask = (j-i >= 8) ? 0xFF : 0xFF-(255>>(j-i));

  i = fl_redshift;
  if (fl_greenshift < i) i = fl_greenshift;
  if (fl_blueshift < i) i = fl_blueshift;
  if (i < 0) {
    fl_extrashift = -i;
    fl_redshift -= i; fl_greenshift -= i; fl_blueshift -= i;
  } else
    fl_extrashift = 0;

}

ulong fl_xpixel(uchar r,uchar g,uchar b) {
  if (!visual_id) figure_out_visual();
  if (fl_redmask) {	// use truecolor visual
    return
      (((r&fl_redmask) << fl_redshift)+
       ((g&fl_greenmask)<<fl_greenshift)+
       ((b&fl_bluemask)<< fl_blueshift)
       ) >> fl_extrashift;
  }
  int i;
  if (r == g && r == b) { // get it out of gray ramp
    i = (r*(FL_NUM_GRAY-1)+128)/256+FL_GRAY_RAMP;
  } else {		// get it out of color cube:
    int rr = (r*(FL_NUM_RED-1)+128)/256;
    int gg = (g*(FL_NUM_GREEN-1)+128)/256;
    int bb = (b*(FL_NUM_BLUE-1)+128)/256;
    i = (bb*FL_NUM_RED+rr)*FL_NUM_GREEN+gg+FL_COLOR_CUBE;
  }
  return fl_xpixel(i);
}

void fl_color(uchar r,uchar g,uchar b) {
  XSetForeground(fl_display, fl_gc, fl_xpixel(r,g,b));
}

