/*	fl_rect.C

	These routines from fl_draw.H are used by the standard boxtypes
	and thus are always linked into an Fl program.

*/

#include <FL/Fl_Object.H>
#include <FL/fl_draw.H>
#include <FL/x.H>

void fl_rect(int x, int y, int w, int h) {
//   if (w<0) {x += w; w = -w;}
//   if (h<0) {y += h; h = -h;}
//   if (!w) w = 1;
//   if (!h) h = 1;
  if (w<=0 || h<=0) return;
  XDrawRectangle(fl_display, fl_window, fl_gc, x, y, w-1, h-1);
}

void fl_rectf(int x, int y, int w, int h) {
//   if (w<0) {x += w; w = -w;}
//   if (h<0) {y += h; h = -h;}
  if (w<=0 || h<=0) return;
  if (w && h) XFillRectangle(fl_display, fl_window, fl_gc, x, y, w, h);
}

void fl_xyline(int x, int y, int x1) {
  XDrawLine(fl_display, fl_window, fl_gc, x, y, x1, y);
}

void fl_xyline(int x, int y, int x1, int y2) {
  XPoint p[3];
  p[0].x = x;  p[0].y = p[1].y = y;
  p[1].x = p[2].x = x1; p[2].y = y2;
  XDrawLines(fl_display, fl_window, fl_gc, p, 3, 0);
}

void fl_xyline(int x, int y, int x1, int y2, int x3) {
  XPoint p[4];
  p[0].x = x;  p[0].y = p[1].y = y;
  p[1].x = p[2].x = x1; p[2].y = p[3].y = y2;
  p[3].x = x3;
  XDrawLines(fl_display, fl_window, fl_gc, p, 4, 0);
}

void fl_yxline(int x, int y, int y1) {
  XDrawLine(fl_display, fl_window, fl_gc, x, y, x, y1);
}

void fl_yxline(int x, int y, int y1, int x2) {
  XPoint p[3];
  p[0].x = p[1].x = x;  p[0].y = y;
  p[1].y = p[2].y = y1; p[2].x = x2;
  XDrawLines(fl_display, fl_window, fl_gc, p, 3, 0);
}

void fl_yxline(int x, int y, int y1, int x2, int y3) {
  XPoint p[4];
  p[0].x = p[1].x = x;  p[0].y = y;
  p[1].y = p[2].y = y1; p[2].x = p[3].x = x2;
  p[3].y = y3;
  XDrawLines(fl_display, fl_window, fl_gc, p, 4, 0);
}

void fl_line(int x, int y, int x1, int y1) {
  XDrawLine(fl_display, fl_window, fl_gc, x, y, x1, y1);
}

void fl_line(int x, int y, int x1, int y1, int x2, int y2) {
  XPoint p[3];
  p[0].x = x;  p[0].y = y;
  p[1].x = x1; p[1].y = y1;
  p[2].x = x2; p[2].y = y2;
  XDrawLines(fl_display, fl_window, fl_gc, p, 3, 0);
}

void fl_loop(int x, int y, int x1, int y1, int x2, int y2) {
  XPoint p[4];
  p[0].x = x;  p[0].y = y;
  p[1].x = x1; p[1].y = y1;
  p[2].x = x2; p[2].y = y2;
  p[3].x = x;  p[3].y = y;
  XDrawLines(fl_display, fl_window, fl_gc, p, 4, 0);
}

void fl_loop(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3) {
  XPoint p[5];
  p[0].x = x;  p[0].y = y;
  p[1].x = x1; p[1].y = y1;
  p[2].x = x2; p[2].y = y2;
  p[3].x = x3; p[3].y = y3;
  p[4].x = x;  p[4].y = y;
  XDrawLines(fl_display, fl_window, fl_gc, p, 5, 0);
}

void fl_polygon(int x, int y, int x1, int y1, int x2, int y2) {
  XPoint p[3];
  p[0].x = x;  p[0].y = y;
  p[1].x = x1; p[1].y = y1;
  p[2].x = x2; p[2].y = y2;
  XFillPolygon(fl_display, fl_window, fl_gc, p, 3, Convex, 0);
}

void fl_polygon(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3) {
  XPoint p[4];
  p[0].x = x;  p[0].y = y;
  p[1].x = x1; p[1].y = y1;
  p[2].x = x2; p[2].y = y2;
  p[3].x = x3; p[3].y = y3;
  XFillPolygon(fl_display, fl_window, fl_gc, p, 4, Convex, 0);
}

////////////////////////////////////////////////////////////////

static Fl_Clip stack[10];
int fl_clipped;
Fl_Clip fl_current_clip;
int fl_clip_state_number; // used by gl_begin.C to update GL clip

void fl_clip(int x, int y, int w, int h) {
  fl_clip_state_number++;
  int r = x+w; int b = y+h;
  if (fl_clipped) {
    int n;
    stack[fl_clipped] = fl_current_clip;
    n = fl_current_clip.x; if (n>x) x=n;
    n = fl_current_clip.r; if (n<r) r=n; if (r<x) r = x;
    n = fl_current_clip.y; if (n>y) y=n;
    n = fl_current_clip.b; if (n<b) b=n; if (b<y) b = y;
  }
  XRectangle R;
  R.x = x; R.y = y; R.width = r-x; R.height = b-y;
//XSetClipOrigin(fl_display, fl_gc, 0, 0);
  XSetClipRectangles(fl_display, fl_gc, 0, 0, &R, 1, 0);
  fl_clipped++;
  fl_current_clip.x = x;
  fl_current_clip.y = y;
  fl_current_clip.r = r;
  fl_current_clip.b = b;
}

void fl_pop_clip() {
  fl_clip_state_number++;
  fl_clipped--;
  if (!fl_clipped) {
    XSetClipMask(fl_display, fl_gc, 0);
    return;
  }
  fl_current_clip = stack[fl_clipped];
  XRectangle R;
  R.x = fl_current_clip.x;
  R.y = fl_current_clip.y;
  R.width = fl_current_clip.r - R.x;
  R.height= fl_current_clip.b - R.y;
//XSetClipOrigin(fl_display, fl_gc, 0, 0);
  XSetClipRectangles(fl_display, fl_gc, 0, 0, &R, 1, 0);
}

////////////////////////////////////////////////////////////////
// obsolete functions:
#if 0

void fl_rect(int x, int y, int w, int h, uchar color) {
  fl_color(color);
  fl_rect(x, y, w, h);
}

void fl_rectf(int x, int y, int w, int h, uchar color) {
  fl_color(color);
  fl_rectf(x, y, w, h);
}

void fl_line(int x, int y, int w, int h, uchar color) {
  fl_color(color);
  fl_line(x, y, x+w, y+h);
}

#endif
