// Stupid X tricks

// Return the Nth overlay visual, or null if none
// Use XFree to free the returned data.
// Another disgusting X interface, based on code extracted and
// purified with great difficulty from XLayerUtil.C:

#include <config.h>
#if HAVE_OVERLAY
#include <FL/Fl.H>
#include <FL/x.H>

// SERVER_OVERLAY_VISUALS property element:
typedef struct _OverlayInfo {
  long overlay_visual;
  long transparent_type;
  long value;
  long layer;
} OverlayInfo;

XVisualInfo *fl_overlay_visual(int n) {
  static OverlayInfo *overlayInfo;
  static int numOverlays;
  if (!numOverlays) {
    numOverlays = -1; // make it fail next time if any error this time
    fl_open_display();
    Atom overlayVisualsAtom =
      XInternAtom(fl_display,"SERVER_OVERLAY_VISUALS",1);
    if (!overlayVisualsAtom) return 0;
    ulong sizeData, bytesLeft;
    Atom actualType;
    int actualFormat;
    if (XGetWindowProperty(fl_display, RootWindow(fl_display, fl_screen),
			   overlayVisualsAtom, 0L, 10000L, False,
			   overlayVisualsAtom, &actualType, &actualFormat,
			   &sizeData, &bytesLeft,
			   (unsigned char **) &overlayInfo)) return 0;
    if (actualType != overlayVisualsAtom ||
	actualFormat != 32 || sizeData < 4) return 0;
    numOverlays = sizeData/4;
    // remove all overlays where pixel 0 is not transparent:
    int i,j;
    for (i=j=0; i < numOverlays; i++) {
      if (overlayInfo[n].transparent_type != 1 || overlayInfo[n].value != 0)
	continue;
      if (j < i) overlayInfo[j] = overlayInfo[i];
      j++;
    }
    numOverlays = j;
  }
  if (n >= numOverlays) return 0;
  XVisualInfo templt;
  templt.visualid = overlayInfo[n].overlay_visual;
  int num;
  XVisualInfo *v = XGetVisualInfo(fl_display, VisualIDMask, &templt, &num);
//XFree((char*)overlayInfo);  // you can do this if we know we are done
  return v;
}

#endif
