// fl_engraved_label.C

// Drawing code for XForms style engraved & embossed labels

#include <FL/Fl.H>
#include <FL/Fl_Object.H>
#include <FL/fl_draw.H>

static int fl_shadow_label(
    const Fl_Label* o, int X, int Y, int W, int H, uchar align)
{
  fl_font(o->font, o->size);
  fl_color(FL_DARK3);
  fl_draw(o->value, X+2, Y+2, W, H, align);
  fl_color(o->color);
  fl_draw(o->value, X, Y, W, H, align);
  return 1;
}

static int fl_engraved_label(
    const Fl_Label* o, int X, int Y, int W, int H, uchar align)
{
  fl_font(o->font, o->size);
  fl_color(FL_LIGHT3);
  fl_draw(o->value, X+1, Y,   W, H, align);
  fl_draw(o->value, X+1, Y+1, W, H, align);
  fl_draw(o->value, X  , Y+1, W, H, align);
  fl_color(FL_DARK3);
  fl_draw(o->value, X-1, Y,   W, H, align);
  fl_draw(o->value, X-1, Y-1, W, H, align);
  fl_draw(o->value, X  , Y-1, W, H, align);
  fl_color(o->color);
  fl_draw(o->value, X, Y, W, H, align);
  return 1;
}

static int fl_embossed_label(
    const Fl_Label* o, int X, int Y, int W, int H, uchar align)
{
  fl_font(o->font, o->size);
  fl_color(FL_LIGHT3);
  fl_draw(o->value, X-1, Y,   W, H, align);
  fl_draw(o->value, X-1, Y-1, W, H, align);
  fl_draw(o->value, X  , Y-1, W, H, align);
  fl_color(FL_DARK3);
  fl_draw(o->value, X+1, Y,   W, H, align);
  fl_draw(o->value, X+1, Y+1, W, H, align);
  fl_draw(o->value, X  , Y+1, W, H, align);
  fl_color(o->color);
  fl_draw(o->value, X, Y, W, H, align);
  return 1;
}

uchar define_FL_SHADOW_LABEL() {
  return Fl::set_labeltype(_FL_SHADOW_LABEL, fl_shadow_label);
}
uchar define_FL_ENGRAVED_LABEL() {
  return Fl::set_labeltype(_FL_ENGRAVED_LABEL, fl_engraved_label);
}
uchar define_FL_EMBOSSED_LABEL() {
  return Fl::set_labeltype(_FL_EMBOSSED_LABEL, fl_embossed_label);
}
