// fl_draw_pixmap.C

// Implemented without using the xpm library (which I can't use because
// it interferes with the color cube used by fl_draw_image).

// Current implementation is cheap and slow, and works best on a full-color
// display.  Transparency is not handled, and colors are dithered to
// the color cube.  Color index is achieved by adding the id
// characters together!  Also mallocs a lot of temporary memory!

// Notice that there is no pixmap file interface.  This is on purpose,
// as I want to discourage programs that require support files to work.
// All data needed by a program ui should be compiled in!!!

#include <config.h>
#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <FL/x.H>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

static int ncolors, chars_per_pixel;

int fl_pixmap_size(/*const*/char * const *data, int &w, int &h) {
  int i = sscanf(data[0],"%d %d %d %d",&w,&h,&ncolors,&chars_per_pixel);
  if (i<4 || w<=0 || h<=0 ||
      chars_per_pixel!=1 && chars_per_pixel!=2) return 0;
  return 1;
}

U32* fl_image_buffer(int w, int h, int& W); // in fl_draw_image.C

int fl_draw_pixmap(/*const*/char * const *data, int x, int y, uchar bg) {
  int w,h;

  if (!fl_pixmap_size(data,w,h)) return 0;
  data++;

  U32 colors[256];

  if (ncolors < 0) {	// FL (non standard) compressed colormap
    ncolors = -ncolors;
    const char *p = *data++;
    // if first color is ' ' it is transparent (put it later to make
    // it not be transparent):
    if (*p == ' ') {
      uchar* c = (uchar*)&colors[' '];
      Fl::get_color(bg, c[0], c[1], c[2]);
      p += 4;
      ncolors--;
    }
    // read all the rest of the colors:
    for (int i=0; i < ncolors; i++) {
      uchar* c = (uchar*)&colors[(*p++)&255];
      *c++ = *p++;
      *c++ = *p++;
      *c   = *p++;
    }
  } else {	// normal XPM colormap with names
    for (int i=0; i<ncolors; i++) {
      const char *p = *data++;
      // the first 1 or 2 characters are the color index:
      int index = *p++;
      if (chars_per_pixel>1) {int t = *p++; index += (t<<4)+(t>>4);}
      // look for "c word", or last word if none:
      const char *previous_word = p;
      for (;;) {
	while (*p && isspace(*p)) p++; char what = *p++;
	while (*p && !isspace(*p)) p++;
	while (*p && isspace(*p)) p++;
	if (!*p) {p = previous_word; break;}
	if (what == 'c') break;
	previous_word = p;
	while (*p && !isspace(*p)) p++;
      }
      // copy the color name and look it up:
      char name[256];
      char *q; for (q = name; *p && !isspace(*p); *q++ = *p++); *q++ = 0;
      uchar *c = (uchar *)&colors[index&255];
      XColor x;
      if (XParseColor(fl_display, fl_colormap, name, &x)) {
	c[0] = x.red>>8; c[1] = x.green>>8; c[2] = x.blue>>8;
      } else { // assumme "None" or "#transparent" for any errors
	// this should be transparent...
	Fl::get_color(bg, c[0], c[1], c[2]);
      }
    }
  }

  int W;
  U32* buffer = fl_image_buffer(w,h,W);
  int extra = W-w;
  U32* q = buffer;
  if (chars_per_pixel==1) {
    for (int y=0; y<h; y++) {
      const char *p = *data++;
      for (int x=0; x<w; x++)
	*q++ = colors[(*p++)&255];
      q += extra;
    }
  } else {
    for (int y=0; y<h; y++) {
      const char *p = *data++;
      for (int x=0; x<w; x++) {
	int index = *p++; int t = *p++; index += (t<<4)+(t>>4);
	*q++ = colors[index&255];
      }
      q += extra;
    }
  }

  fl_draw_image((const uchar *)buffer,x,y,w,h,4,W*4);
  return 1;
}

