// fl_diamond_box.C

// Box drawing code for an obscure box type.
// These box types are in seperate files so they are not linked
// in if not used.

#include <FL/Fl.H>
#include <FL/fl_draw.H>

static void fl_diamond_up_box(int x,int y,int,int h,uchar bgcolor) {
  h &= -2;
  int x1 = x+h/2;
  int y1 = y+h/2;
  fl_color(bgcolor); fl_polygon(x+3, y1, x1,y+3, x+h-3,y1, x1,y+h-3);
  fl_color(FL_LIGHT3); fl_line(x+1, y1, x1, y+1, x+h-1, y1);
  fl_color(FL_LIGHT2); fl_line(x+2, y1, x1, y+2, x+h-2, y1);
  fl_color(FL_LIGHT1); fl_line(x+3, y1, x1, y+3, x+h-3, y1);
  fl_color(FL_DARK1); fl_line(x+3, y1, x1, y+h-3, x+h-3, y1);
  fl_color(FL_DARK2); fl_line(x+2, y1, x1, y+h-2, x+h-2, y1);
  fl_color(FL_DARK3); fl_line(x+1, y1, x1, y+h-1, x+h-1, y1);
  fl_color(FL_GRAY0); fl_loop(x, y1, x1, y, x+h, y1, x1, y+h);
}

static void fl_diamond_down_box(int x,int y,int,int h,uchar bgcolor) {
  h &= -2;
  int x1 = x+h/2;
  int y1 = y+h/2;
  fl_color(FL_DARK1); fl_line(x+0, y1, x1, y+0, x+h-0, y1);
  fl_color(FL_DARK2); fl_line(x+1, y1, x1, y+1, x+h-1, y1);
  fl_color(FL_DARK3); fl_line(x+2, y1, x1, y+2, x+h-2, y1);
  fl_color(FL_LIGHT3); fl_line(x+2, y1, x1, y+h-2, x+h-2, y1);
  fl_color(FL_LIGHT2); fl_line(x+1, y1, x1, y+h-1, x+h-1, y1);
  fl_color(FL_LIGHT1); fl_line(x+0, y1, x1, y+h-0, x+h-0, y1);
  fl_color(bgcolor); fl_polygon(x+3, y1, x1,y+3, x+h-3,y1, x1,y+h-3);
  fl_color(FL_GRAY0); fl_loop(x+3, y1, x1, y+3, x+h-3, y1, x1, y+h-3);
}

uchar define_FL_DIAMOND_BOX() {
  Fl::set_boxtype(_FL_DIAMOND_DOWN_BOX,fl_diamond_down_box);
  return Fl::set_boxtype(_FL_DIAMOND_UP_BOX,fl_diamond_up_box);
}
