// fl_cursor.C

// Change the current cursor.

// Under X the cursor is attached to the X window.  I tried to hide
// this and pretend that changing the cursor is a drawing function.
// This avoids a field in the Fl_Window, and I suspect is more
// portable to other systems.

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/x.H>
#include <X11/cursorfont.h>
#include <FL/fl_draw.H>

void fl_cursor(uchar c, uchar fg, uchar bg) {
  Fl_Window::current()->cursor(c,fg,bg);
}

void Fl_Window::cursor(uchar c, uchar fg, uchar bg) {
  Cursor cursor;
  int deleteit = 0;
  if (!c) {
    cursor = None;
  } else if ((c-1)*2>=XC_num_glyphs) {
    static Cursor blank;
    if (!blank) {
      // make a blank cursor
      static char data[1] = {0};
      XColor dummy;
      Pixmap p = XCreateBitmapFromData(
	fl_display, RootWindow(fl_display, fl_screen), data, 1, 1);
      blank = XCreatePixmapCursor(fl_display, p, p, &dummy, &dummy, 0, 0);
      XFreePixmap(fl_display, p);
    }
    cursor = blank;
  } else {
    cursor = XCreateFontCursor(fl_display, (c-1)*2);
    deleteit = 1;
    XColor fgc;
    uchar r,g,b;
    Fl::get_color(fg,r,g,b);
    fgc.red = r<<8; fgc.green = g<<8; fgc.blue = b<<8;
    XColor bgc;
    Fl::get_color(bg,r,g,b);
    bgc.red = r<<8; bgc.green = g<<8; bgc.blue = b<<8;
    XRecolorCursor(fl_display, cursor, &fgc, &bgc);
  }
  XDefineCursor(fl_display, xid(), cursor);
  if (deleteit) {
    XFreeCursor(fl_display, cursor);
  }
}

