// fl_arc.C

// Utility for drawing arcs and circles.  They are added to
// the current fl_begin/fl_vertex/fl_end path.
// Current implementation produces a 16-sided polygon.
// That's pretty lame.

#include <FL/fl_draw.H>

#define RN	4
static float offset[RN+1] = {
  0.5, 0.382683/2+.5, 0.707106/2+.5, 0.923879/2+.5, 1.0
};

void fl_arc(float x,float y,float w,float h,int start,int end) {
  float v[2];
  start = (start*RN/90)%(RN*4);
  end = (end*RN/90)%(RN*4);
  for (int i = start; ; i = (i+1)%(RN*4)) {
    int j = i/RN;
    int k = i%RN;
    if (j&1) {
      if (j&2) {
	v[0] = offset[k]; v[1] = offset[RN-k];
      } else {
	v[0] = 1-offset[k]; v[1] = 1-offset[RN-k];
      }
    } else {
      if (j&2) {
	v[0] = 1-offset[RN-k]; v[1] = offset[k];
      } else {
	v[0] = offset[RN-k]; v[1] = 1-offset[k];
      }
    }
    fl_vertex(v[0]*w+x, v[1]*h+y);
    if (i == end) break;
  }
}

void fl_arc(float x,float y,float r,int start,int end) {
  fl_arc(x-r,y-r,2*r,2*r,start,end);
}

#if 0 // portable version.  X-specific one in fl_vertex.C
void fl_circle(float x,float y,float w,float h) {
  int k;
  for (k = 0; k<RN; k++)
    fl_vertex(offset[RN-k]*w+x, (1-offset[k])*h+y);
  for (k = 0; k<RN; k++)
    fl_vertex((1-offset[k])*w+x, (1-offset[RN-k])*h+y);
  for (k = 0; k<RN; k++)
    fl_vertex((1-offset[RN-k])*w+x, offset[k]*h+y);
  for (k = 0; k<RN; k++)
    fl_vertex(offset[k]*w+x, offset[RN-k]*h+y);
}

void fl_circle(float x,float y,float r) {
  fl_circle(x-r,y-r,2*r,2*r);
}
#endif
