/* expand a file name by substuting environment variables and
   home directories and making double slash mean root.
   Returns true if any changes were made.
   to & from may be the same buffer.
*/

#include <FL/filename.H>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>

#ifdef WIN32
inline int isdirsep(char c) {return c=='/' || c=='\\';}
#else
#define isdirsep(c) ((c)=='/')
#endif

int filename_expand(char *to,const char *from) {

  char temp[FNAMEMAX];
  strcpy(temp,from);
  const char *start = temp;
  const char *end = temp+strlen(temp);

  int ret = 0;

  for (char *a=temp; a<end; ) {	// for each slash component
#ifdef WIN32
    // A: means delete everything before it
    if (a[0] && a[1]==':') {
      if (a != start) {ret++; start = a;}
      a = a+2;
      continue;
    }
#endif
    char *e; for (e=a; e<end && !isdirsep(*e); e++); // find next slash
    const char *value = 0; // this will point at substitute value
    switch (*a) {
#ifdef WIN32
    case '\\':
#endif
    case '/':	// double slash means root
      if (a != start) {ret++; start = a;}
      break;
    case '~':	// a home directory name
      if (e <= a+1) {	// current user's directory
	value = getenv("HOME");
      } else {	// another user's directory
	struct passwd *pwd;
	char t = *e; *(char *)e = 0; pwd = getpwnam(a+1); *(char *)e = t;
	if (pwd) value = pwd->pw_dir;
      }
      break;
    case '$':		/* an environment variable */
      {char t = *e; *(char *)e = 0; value = getenv(a+1); *(char *)e = t;}
      break;
    }
    if (value) {
      int t = strlen(value); if (isdirsep(value[t-1])) t--;
      memmove(a+t, e, end+1-e);
      end = a+t+(end-e);
      memcpy(a, value, t);
      ret++;
    } else {
      a = e+1;
    }
  }
  strcpy(to,start);
  return ret;
}
