// This method is in it's own source file so that stdlib and stdio
// do not need to be included in Fl.C:

#include <FL/Fl.H>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

void Fl::default_abort(const char *format, ...) {
    va_list args;
    va_start(args, format);
    vfprintf(stderr, format, args);
    va_end(args);
    fputc('\n', stderr);
//  abort(); // this produces a core dump, probably not desirable?
    ::exit(1);
}

void (*Fl::abort)(const char *,...) = Fl::default_abort;
