// Fl_Window_fullscreen.C

#include <FL/Fl.H>
#include <FL/Fl_Window.H>

// turn the border on and off:
int Fl_Window::border(int b) {
  if (b) {
    if (border()) return 0;
    set_flag(FL_BORDER);
  } else {
    if (!border()) return 0;
    clear_flag(FL_BORDER);
  }
  sendxjunk();
  return 1;
}

void Fl_Window::fullscreen() {
  border(0);
  x(1); // force it to call XResizeWindow()
  resize(0,0,Fl::w(),Fl::h());
}

void Fl_Window::fullscreen_off(int X,int Y,int W,int H) {
  resize(X,Y,W,H);
  border(1);
}
