/*	Fl_Value_Slider.C	*/

#include <FL/Fl.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/fl_draw.H>
#include <math.h>
#include <stdio.h>

Fl_Value_Slider::Fl_Value_Slider(int x,int y,int w,int h, const char*l)
: Fl_Slider(x,y,w,h,l) {
    precision_ = 2;
    step(.001);
    textfont_ = FL_HELVETICA;
    textsize_ = 10;
    textcolor_ = FL_BLACK;
}

void Fl_Value_Slider::draw() {
    int sxx = x(), syy = y(), sww = w(), shh = h();
    int bxx = x(), byy = y(), bww = w(), bhh = h();
    if (horizontal()) {
	bww = 35; sxx += 35; sww -= 35;
    } else {
	syy += 25; bhh = 25; shh -= 25;
    }
    Fl_Slider::draw(sxx,syy,sww,shh);
    fl_draw_box(box(),bxx,byy,bww,bhh,color());
    char valstr[50];
    sprintf(valstr,"%.*f", precision(), value());
    fl_font(textfont(), textsize());
    fl_color(textcolor());
    fl_draw(valstr, bxx, byy, bww, bhh, FL_ALIGN_CENTER);
}

void Fl_Value_Slider::precision(uchar a) {
  precision_ = a;
  float step1 = 1; for (int i=0; i<a; i++) step1 = step1/10;
  if (step1 > step()) step(step1);
}

int Fl_Value_Slider::handle(int event) {
  int sxx = x(), syy = y(), sww = w(), shh = h();
  if (horizontal()) {
    sxx += 35; sww -= 35;
  } else {
    syy += 25; shh -= 25;
  }
  return Fl_Slider::handle(event,sxx,syy,sww,shh);
}

// End of Fl_Value_Slider.C
