// Fl_Text_Adjuster.C

// Fl object for drag-adjusting a floating point value.

#include <FL/Fl.H>
#include <FL/Fl_Text_Adjuster.H>
#include <stdio.h>
#include <stdlib.h>

int Fl_Text_Adjuster::value(float v) {
  char buf[128];
  sprintf(buf,"%g",v);
  int r = Fl_Input::value(buf);
  mark(position()); // turn off highlight
  return r;
}

float Fl_Text_Adjuster::value() const {
  return atof(Fl_Input::value());
}

int Fl_Text_Adjuster::handle(int event) {
  float v;
  int delta;
  float s;
  int mx = Fl::event_x();
  static int changed, drag, ix;
  static float ival, pval;
  switch (event) {
  case FL_PUSH:
    ix = mx;
    drag = Fl::event_button();
    pval = ival = value();
    changed = 0;
    return 1;
  case FL_DRAG:
    delta = Fl::event_x()-ix;
    if (delta > 5) delta -= 5;
    else if (delta < -5) delta += 5;
    else delta = 0;
    s = step_ ? step_ : (maximum_-minimum_)/1000;
    switch (drag) {
    case 2: v = ival + delta*s*5; break;
    case 3: v = ival + delta*s*20; break;
    default: v = ival + delta*s; break;
    }
    if (v < minimum_ && ival > minimum_) v = minimum_;
    if (v > maximum_ && ival < maximum_) v = maximum_;
    if (v != pval) {pval = v; value(v); changed = 1; do_callback();}
    return 1;
  case FL_RELEASE:
    if (!changed) {
      Fl_Input::handle(FL_PUSH);
      return Fl_Input::handle(FL_RELEASE);
    }
    return 1;
  default:
    return Fl_Input::handle(event);
  }
}

Fl_Text_Adjuster::Fl_Text_Adjuster(int x,int y,int w,int h,const char *l)
: Fl_Input(x,y,w,h,l) {
  type(FL_FLOAT_INPUT);
  minimum_ = 0;
  maximum_ = 1;
  step_ = 0;
  value(0);
}
