// Fl_Return_Button.C

#include <FL/Fl.H>
#include <FL/Fl_Return_Button.H>
#include <FL/fl_draw.H>

int fl_return_arrow(int x,int y,int w,int h) {
  int size = w; if (h<size) size = h;
  int d = (size+2)/4; if (d<3) d = 3;
  int t = (size+9)/12; if (t<1) t = 1;
  int x0 = x+(w-2*d-2*t-1)/2;
  int x1 = x0+d;
  int y0 = y+h/2;
  fl_color(FL_LIGHT3);
  fl_line(x0,y0,x1,y0+d);
  fl_yxline(x1,y0+d,y0+t,x1+d+2*t,y0-d);
  fl_yxline(x1,y0-t,y0-d);
  fl_color(FL_DARK3);
  fl_line(x0,y0,x1+1,y0-d-1);
  fl_xyline(x1+1,y0-t,x1+d,y0-d,x1+d+2*t);
  return 1;
}

void Fl_Return_Button::draw() {
  if (type() == FL_HIDDEN_BUTTON) return;
  int col = value() ? color2() : color();
//if (col == FL_GRAY && Fl::belowmouse()==this) col = FL_LIGHT1;
  draw_box(value() ? (down_box()?down_box():box()+1) : box(), col);
  int W = w()/3;
  if (W < 24) {W = w()/2; if (W > 24) W = 24;}
  if (2*h() < W) W = 2*h();
  
  fl_return_arrow(x()+w()-W,y(),W,h());
  draw_label(x(),y(),w()-W/2,h());
}

int Fl_Return_Button::handle(int event) {
  if (event == FL_SHORTCUT &&
      (Fl::event_key() == FL_Enter || Fl::event_key() == FL_KP_Enter)) {
    do_callback();
    return 1;
  } else
    return Fl_Button::handle(event);
}
