// Fl_Pixmap.C

// Draws X pixmap data, keeping it stashed in a server pixmap so it
// redraws fast.

// See fl_draw_pixmap.C for code used to get the actual data into pixmap.
// Implemented without using the xpm library (which I can't use because
// it interferes with the color cube used by fl_draw_image).

#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <FL/x.H>
#include <FL/Fl_Object.H>
#include <FL/Fl_Pixmap.H>

void fl_draw(Fl_Pixmap* b,int x,int y,int w,int h) {
  if (!b->id) {
    if (!b->w) {if (!fl_pixmap_size(b->data,b->w,b->h)) {b->w=0; return;}}
    b->id = XCreatePixmap(fl_display,fl_window,b->w,b->h,fl_visual->depth);
    Window t = fl_window; fl_window = b->id;
    fl_draw_pixmap(b->data,0,0,b->bg);
    fl_window = t;
  }
  int ox, oy;
  if (b->w >= w) ox = (b->w-w)/2; else
    {ox = 0; x += (w-b->w)/2; w = b->w;}
  if (b->h >= h) oy = (b->h-h)/2; else
    {oy = 0; y += (h-b->h)/2; h = b->h;}
  XCopyArea(fl_display, b->id, fl_window, fl_gc, ox, oy, w, h, x, y);
}

Fl_Pixmap::~Fl_Pixmap() {
  if (id) XFreePixmap(fl_display, id);
}

static int pixmap_labeltype(
    const Fl_Label* o, int x, int y, int w, int h, uchar a)
{
  Fl_Pixmap* b = (Fl_Pixmap*)(o->value);
  if (!b->w) fl_pixmap_size(b->data,b->w,b->h);
  if (a & FL_ALIGN_LEFT) w = b->w;
  else if (a & FL_ALIGN_RIGHT) {x += w-b->w; w = b->w;}
  if (a & FL_ALIGN_TOP) h = b->h;
  else if (a & FL_ALIGN_BOTTOM) {y += h-b->h; h = b->h;}
  fl_draw(b,x,y,w,h);
  return 1;
}

void Fl_Pixmap::label(Fl_Object* o) {
  bg = o->color();
  Fl::set_labeltype(_FL_PIXMAP_LABEL, pixmap_labeltype);
  o->label(_FL_PIXMAP_LABEL, (const char*)this);
}
