// Fl_Menu_add.C

// This is a base class for all items that have a menu:
//	Fl_Menu_Bar, Fl_Menu_Button, Fl_Choice
// This provides storage for a menu item, functions to add/modify/delete
// items, and a call for when the user picks a menu item.

// These functions are for emulation of Forms and for dynamically
// changing the menus.  They are in this source file so they are
// not linked in if not used, which is what will happen if the
// the program only uses constant menu tables.

// Not at all guaranteed to be Forms compatable, especially with any
// string with a % sign in it!

#include <FL/Fl_Menu_.H>
#include <string.h>
#include <stdlib.h>

int Fl_Menu::add(
    const char *text,
    const char *bind,
    Fl_Callback *cb,
    void *data,
    int flags)
{
    Fl_Menu *m;
    const char *p;
    char *q,buf[60];

    int size = this->size();

    m = this;
    for (;;) {    /* do all the supermenus: */

	/* fill in the buf with /name, changing \x to x: */
	q = buf; *q++ = '/';
	for (p=text; *p && *p != '/'; *q++ = *p++) if (*p=='\\') p++;
	*q = 0;

	if (*p != '/') break; /* not a menu title */
	text = p+1;	/* point at item title */

	/* find a matching menu title: */
	for (; m->text; m = m->next())
	    if (!strcmp(buf,m->text)) break;

	if (!m->text) { /* create a new menu */
	    memmove(m+2,m,sizeof(Fl_Menu)*(this+size-m));
	    m->text = strdup(buf);
	    m->callback = 0;
	    m->shortcut = 0;
	    (m+1)->text = 0;
	    size += 2;
	}
	m++;	/* go into the menu */
    }

    /* find a matching menu item: */
    for (; m->text; m = m->next())
	if (!strcmp(m->text,buf+1)) break;

    if (!m->text) {	/* add a new menu item */
	memmove(m+1,m,sizeof(Fl_Menu)*(this+size-m));
	size++;
	m->text = strdup(buf+1);
    }

    /* fill it in */
    m->shortcut = bind;
    m->callback = cb;
    m->argument = data;
    m->flags = flags;

    return m-this;
}

// this is really lame, it will crash if this many items are added:
#define FL_MENU_MAXITEMS	128

int Fl_Menu_::add(const char *t,const char *s,
		  Fl_Callback *c,void *v,int f) {
  if (!menu_) {
    value_ = menu_ = new Fl_Menu[FL_MENU_MAXITEMS+1];
    alloc = 1;
    menu_[0].text = 0;
  }
  return menu_->add(t,s,c,v,f);
}

int Fl_Menu_::add(const char *str) {
  char buf[128];
  int r = 0;
  while (*str) {
    char *shortcut = 0;
    char *c;
    for (c = buf; *str && *str != '|'; str++) {
      if (*str == '\t') {*c++ = 0; shortcut = c;}
      else *c++ = *str;
    }
    *c = 0;
    r = add(buf, shortcut?strdup(shortcut):0, 0, 0, 0);
    if (*str) str++;
  }
  return r;
}

void Fl_Menu_::replace(int i, const char *str) {
  if (i<0 || i>=size()) return;
  if (alloc) free((void *)menu_[i].text);
  menu_[i].text = strdup(str);
}

void Fl_Menu_::remove(int i) {
  int n = size();
  if (i<0 || i>=n) return;
  if (alloc) free((void *)menu_[i].text);
  memmove(&menu_[i],&menu_[i+1],(n-i)*sizeof(Fl_Menu));
}

// end of Fl_Menu_.C
