/*	Fl_Menu_Window.H

	This is the window type used by Fl_Menu to make the pop-ups.
	It draws in the overlay planes, if possible, and does other
	fun things such as turning on override_redirect.

	Also here is the implementation of the mouse & keyboard grab,
	which are used so that clicks outside the program's windows
	can be used to dismiss the menus.

*/

#include <config.h>
#include <FL/Fl.H>
#include <FL/x.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Menu_Window.H>

#if HAVE_OVERLAY

XVisualInfo *fl_overlay_visual(int);
static XVisualInfo *vis;
static Colormap colormap_;
static int tried;

#endif

void Fl_Menu_Window::show() {
  if (shown()) {Fl_Single_Window::show(); return;}
  if (!border()) fl_override_redirect = 1;
#if HAVE_OVERLAY
  fl_open_display();
  if (!vis && !tried) {
    tried = 1;
    vis = fl_overlay_visual(0);
    if (vis) colormap_ =
	       XCreateColormap(fl_display, RootWindow(fl_display,fl_screen),
				 vis->visual, AllocNone);
  }
  if (vis) {
    fl_background_pixel = 0; // clear
    make_xid(vis);
    fl_background_pixel = -1;
  } else
#endif
    Fl_Single_Window::show();
  fl_override_redirect = 0;
}

ulong Fl_Menu_Window::colormap() const {
  return
#if HAVE_OVERLAY
    vis ? colormap_ :
#endif
    Fl_Single_Window::colormap();
}

#if HAVE_OVERLAY
static GC gc;	// the GC used by all X windows
#endif

void Fl_Menu_Window::flush() {
#if HAVE_OVERLAY
  if (!vis) {Fl_Single_Window::flush(); return;}
  fl_window = xid();
  if (!gc) gc = XCreateGC(fl_display, xid(), 0, 0);
  fl_gc = gc;
  // set the colors *after* the -bg switches have been parsed:
  if (tried == 1) {
    fl_alloc_color(colormap_,FL_LIGHT1);
    fl_alloc_color(colormap_,FL_BLACK);
    fl_alloc_color(colormap_,FL_WHITE);
    tried = 2;
  }
  fl_overlay = 1;
  if (damage()==2) {
    fl_clip(damage_box.x, damage_box.y,
	    damage_box.r-damage_box.x, damage_box.b-damage_box.y);
    draw();
    fl_pop_clip();
  } else {
    draw();
  }
  clear_damage();
  damage_box.r = 0;
  fl_overlay = 0;
#else
  Fl_Single_Window::flush();
#endif
}

void Fl_Menu_Window::erase() {
#if HAVE_OVERLAY
  if (!gc || !visible()) return;
//XSetForeground(fl_display, gc, 0);
//XFillRectangle(fl_display, xid(), gc, 0, 0, w(), h());
  XClearWindow(fl_display, xid());
#endif
}

// Fix the colormap flashing on Maximum Impact Graphics by erasing the
// menu before unmapping it:
void Fl_Menu_Window::hide() {
  erase();
  Fl_Single_Window::hide();
}

Fl_Menu_Window::~Fl_Menu_Window() {
  hide();
}

////////////////////////////////////////////////////////////////
// grab the events and send them to a currently-displayed window.
// this is done when the first menu is displayed and undone when
// the last one is removed:

void Fl::grab() {
  XGrabPointer(fl_display,
	       first()->xid(),
	       1,
	       ButtonPressMask|ButtonReleaseMask|
	       ButtonMotionMask|PointerMotionMask,
	       GrabModeAsync,
	       GrabModeAsync, 
	       None,
	       0,
	       event_time());
  XGrabKeyboard(fl_display,
		first()->xid(),
		1,
		GrabModeAsync,
		GrabModeAsync, 
		event_time());
}

void Fl::release() {
  XUngrabKeyboard(fl_display, event_time());
  XUngrabPointer(fl_display, event_time());
  // this flush is done in case the picked menu item goes into
  // an infinite loop, so we don't leave the X server locked up:
  XFlush(fl_display);
}

// end of Fl_Menu_Window.C
