// Fl_Light_Button.C

// A subclass of Fl_Button that indicates the "on" state with a
// light-up indented area.  These were a unique feature of Forms and
// widely used by SGI applications based on it.

#include <FL/Fl.H>
#include <FL/Fl_Light_Button.H>
#include <FL/fl_draw.H>

void Fl_Light_Button::draw() {
  /* Draw the box */
  draw_box(box(),/*Fl::belowmouse()==this ? FL_LIGHT1 :*/ FL_GRAY);
  /* Calculate and draw the light */
  int yy = h()/6;
  int hh = h()-2*yy;
  int ww = hh/2+1;
  int xx = yy*2; if (w()<ww+2*xx) xx = (w()-ww)/2;
  fl_draw_box(FL_THIN_DOWN_BOX,x()+xx,y()+yy,ww,hh,value()?color2():color());
  draw_label(x()+xx+ww,y(),w()-xx-ww,h());
}

int Fl_Light_Button::handle(int event) {
  switch (event) {
  case FL_ENTER:
  case FL_LEAVE:
//  redraw();
  default:
    return Fl_Button::handle(event);
  }
}

Fl_Light_Button::Fl_Light_Button(int x,int y,int w,int h, const char *l)
: Fl_Button(x,y,w,h,l) {
  color2(FL_YELLOW); // Forms set color(39);
  align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
}
