// Fl_Image.C

// Draw a image in a box.

#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <FL/x.H>
#include <FL/Fl_Object.H>
#include <FL/Fl_Image.H>

void fl_draw(Fl_Image* b,int x,int y,int w,int h) {
  if (!b->id) {
    b->id = XCreatePixmap(fl_display,fl_window,b->w,b->h,fl_visual->depth);
    Window t = fl_window; fl_window = b->id;
    fl_draw_image(b->array, 0, 0, b->w, b->h, b->d, b->ld);
    fl_window = t;
  }
  int ox, oy;
  if (b->w < w) {ox = 0; x += (w-b->w)/2; w = b->w;}
  else {ox = (b->w-w)/2;}
  if (b->h < h) {oy = 0; y += (h-b->h)/2; h = b->h;}
  else {oy = (b->h-h)/2;}
  XCopyArea(fl_display, b->id, fl_window, fl_gc, ox, oy, w, h, x, y);
}

Fl_Image::~Fl_Image() {
  if (id) XFreePixmap(fl_display, id);
}

static int image_labeltype(
    const Fl_Label* o, int x, int y, int w, int h, uchar a)
{
  Fl_Image* b = (Fl_Image*)(o->value);
  if (a & FL_ALIGN_LEFT) w = b->w;
  else if (a & FL_ALIGN_RIGHT) {x += w-b->w; w = b->w;}
  if (a & FL_ALIGN_TOP) h = b->h;
  else if (a & FL_ALIGN_BOTTOM) {y += h-b->h; h = b->h;}
  fl_color(o->color);
  fl_draw(b,x,y,w,h);
  return 1;
}

void Fl_Image::label(Fl_Object* o) {
  Fl::set_labeltype(_FL_IMAGE_LABEL, image_labeltype);
  o->label(_FL_IMAGE_LABEL, (const char*)this);
}
