// Fl_Gl_Overlay.C

// Methods on Fl_Gl_Window that create an overlay window.  Because
// many programs don't need the overlay, this is seperated into this
// source file so it is not linked in if not used.

#include <config.h>
#if HAVE_GL

#include <FL/Fl.H>
#include <FL/Fl_Gl_Window.H>
#include <FL/x.H>
#include <GL/glx.h>
#include <stdlib.h>

#if HAVE_OVERLAY

static int OVERLAY[] = {GLX_LEVEL, 1, None};

class _Fl_Gl_Overlay : public Fl_Gl_Window {
  void draw();
  void show();
public:
  _Fl_Gl_Overlay(int x, int y, int w, int h) :
    Fl_Gl_Window(x,y,w,h) {mode(OVERLAY);}
};

void _Fl_Gl_Overlay::draw() {
  glClear(GL_COLOR_BUFFER_BIT);
  Fl_Gl_Window *w = (Fl_Gl_Window *)parent();
  uchar save_valid = w->valid_;
  w->valid_ = valid_;
  w->draw_overlay();
  valid_ = w->valid_;
  w->valid_ = save_valid;
}

void _Fl_Gl_Overlay::show() {
  int newcmap = (!g || !colormap());
  fl_background_pixel = 0;
  Fl_Gl_Window::show();
  fl_background_pixel = -1;
  if (newcmap) {
    fl_alloc_color(colormap(),overlay_color);
    fl_alloc_color(colormap(),FL_BLACK);
    fl_alloc_color(colormap(),FL_WHITE);
  }
}

#endif // HAVE_OVERLAY

////////////////////////////////////////////////////////////////

int Fl_Gl_Window::can_do_overlay() {
#if HAVE_OVERLAY
  return can_do(OVERLAY);
#else
  return 0;
#endif
}

void Fl_Gl_Window::redraw_overlay() {
  if (!overlay) {
#if HAVE_OVERLAY
    if (can_do(OVERLAY)) {
      overlay = new _Fl_Gl_Overlay(0,0,w(),h());
      add_resizable(*overlay);
    } else
#endif
      overlay = this; // fake the overlay
  }
  if (shown()) {
    if (overlay == this) {
      damage(4); // this bit causes only overlay to be drawn, if possible
    } else if (!overlay->shown())
      overlay->show();
    else {
      overlay->redraw();
    }
  }
}

void Fl_Gl_Window::make_overlay_current() {
#if HAVE_OVERLAY
  if (!overlay) {
    overlay = new _Fl_Gl_Overlay(0,0,w(),h());
    add_resizable(*overlay);
    if (shown()) overlay->show();
  } else {
    if (!overlay->shown()) overlay->show();
    overlay->make_current();
  }
#endif
}

void Fl_Gl_Window::hide_overlay() {
#if HAVE_OVERLAY
  if (overlay && overlay!=this) overlay->hide();
#endif
}

uchar Fl_Gl_Window::overlay_color = 1;

#endif
