// Internal interface to select glX visuals
// Called by Fl_Gl_Window.C and by gl_visual() (in gl_mode.C)

#ifndef Fl_Gl_Choice_H
#define Fl_Gl_Choice_H

// one of these structures is returned:
class Fl_Gl_Choice {
  int mode;
  const int *alist;
  Fl_Gl_Choice *next;
public:
  XVisualInfo *vis;	// the visual to use
  Colormap colormap;	// a colormap to use
  uchar r,d,o;		// rgb mode, double buffered, overlay flags
  // either use mode flags from gl_draw.H or a literal glX int list.
  // one of the two arguments must be zero!
  static Fl_Gl_Choice *find(int mode,const int *);
};

#endif
