/*	Fl_Font.H

	Private data structure to hold a font we have found from X.
	This is used by fl_font.C and gl_draw.C

*/

#ifndef FL_FONT_
#define FL_FONT_

class Fl_Font {
public:
  Fl_Font *next;	// linked list of sizes of this style
  int minsize;		// smallest point size that should use this
  int maxsize;		// largest point size that should use this
  XFontStruct *font;	// X font information, 0 for display list
#if HAVE_GL
  unsigned int listbase; // base of display list
  uchar madelistbase;	// if false, above not yet initialized
#endif
  uchar number;		// which slot in FL's font table
  Fl_Font(const char *, uchar);
  ~Fl_Font();
};

extern Fl_Font *fl_current_font;

void fl_draw(const char *, int x, int y, int w, int h, uchar align, 
	     void (*callthis)(const char *, int n, int x, int y));

#endif
