// Fl_Dial.C

// A circular dial control, like xv uses.  From Forms.

#include <FL/Fl.H>
#include <FL/Fl_Dial.H>
#include <FL/fl_draw.H>
#include <FL/x.H>
#include <stdlib.h>
#include <math.h>

void Fl_Dial::draw(int x,int y,int w,int h) {
  fl_draw_box(box(),x,y,w,h,FL_GRAY);
  if (box()>FL_FLAT_BOX) {if (w>20) {x+=5; w-=10;} if (h>20) {y+=5;h-=10;}}
  float angle = 270.0*(value_-min)/(max-min);
  if (type() == FL_FILL_DIAL) {
    int i = int(angle*64); if (i<=0) i = 1;
    fl_color(color());
    XFillArc(fl_display,fl_window,fl_gc,x,y,w,h,225*64,360*64-i);
    fl_color(color2());
    XFillArc(fl_display,fl_window,fl_gc,x,y,w,h,225*64-i,i);
  } else {
    fl_color(color());
    XFillArc(fl_display,fl_window,fl_gc,x,y,w,h,0,360*64);
  }
  fl_color(FL_BLACK);
  XDrawArc(fl_display,fl_window,fl_gc,x,y,w,h,0,360*64);
  fl_push_matrix();
  fl_translate(x+w/2-.5, y+h/2-.5);
  fl_scale(w-1,h-1);
  if (type() == FL_FILL_DIAL) {
    fl_rotate(225);
    fl_begin_line(); fl_vertex(0,0); fl_vertex(.5,0); fl_end();
  }
  fl_rotate(-angle);
  if (type() == FL_LINE_DIAL) {
    fl_color(color2());
    fl_begin_polygon();
    fl_vertex(0.0,0.0);
    fl_vertex(-0.04,0.0);
    fl_vertex(-0.25,0.25);
    fl_vertex(0.0,0.04);
    fl_end();
    fl_color(FL_BLACK);
    fl_begin_loop();
    fl_vertex(0.0,0.0);
    fl_vertex(-0.04,0.0);
    fl_vertex(-0.25,0.25);
    fl_vertex(0.0,0.04);
    fl_end();
  } else if (type() == FL_FILL_DIAL) {
    fl_begin_line(); fl_vertex(0,0); fl_vertex(.5,0); fl_end();
  } else {
    fl_color(color2());
    fl_begin_polygon(); fl_circle(-0.20,0.20,0.07); fl_end();
    fl_color(FL_BLACK);
    fl_begin_loop(); fl_circle(-0.20,0.20,0.07); fl_end();
  }
  fl_pop_matrix();
}

void Fl_Dial::draw() {
  draw(x(),y(),w(),h());
  draw_label();
}

int Fl_Dial::handle(int event,int x,int y,int w, int h) {
  switch (event) {
  case FL_PUSH:
  case FL_RELEASE:
  case FL_DRAG: {
    float angle;
    float val = value_;
    int mx = Fl::event_x()-x-w/2;
    int my = Fl::event_y()-y-h/2;
    if (!mx && !my) return 1;
    if (abs(mx) > abs(my)) {
      angle = atan(-(float)my/mx);
      if (mx>0) angle = 1.25*M_PI - angle;
      else angle = 0.25*M_PI - angle;
    } else {
      angle = atan(-(float)mx/my);
      if (my<0) angle = 0.75*M_PI + angle;
      else angle = -0.25*M_PI + angle;
    }
    if (angle<-0.25*M_PI) angle += 2.0*M_PI;
    val = min + (max-min)*angle/(1.5*M_PI);
    if (step_) val = int(val/step_+0.5)*step_;
    if (val < min) val = min;
    if (val > max) val = max;
    if (val != value_ && fabs(val-value_) < (max-min)/2.0) {
      value_ = val;
      set_changed();
      redraw();
    }}
    if (!(when() & FL_WHEN_CHANGED ||
	  (when() & FL_WHEN_RELEASE) && event == FL_RELEASE)) return 1;
    if (changed() || when()&FL_WHEN_NOT_CHANGED) {
      clear_changed(); do_callback();}
    return 1;
  default:
    return 0;
  }
}

int Fl_Dial::handle(int e) {
  return handle(e,x(),y(),w(),h());
}

Fl_Dial::Fl_Dial(int x,int y,int w,int h,const char *l)
: Fl_Object(x,y,w,h,l) {
  box(FL_NO_BOX);
  color2(FL_INACTIVE_COLOR); // was 37
  align(FL_ALIGN_BOTTOM);
  when(FL_WHEN_CHANGED);
  min = 0;
  max = 1;
  value_ = .5;
  step_ = 0;
}

int Fl_Dial::value(float v) {
  clear_changed();
  if (value_ != v) {value_ = v; redraw(); return 1;}
  return 0;
}

void Fl_Dial::bounds(float a, float b) {
  if (min != a || max != b) {min = a; max = b; redraw();}
}
