// Fl_Check_Button.C

// A subclass of Fl_Button that always draws as a diamond box.  This
// diamond is smaller than the object size and can be surchecked by
// another box type, for compatability with Forms.

#include <FL/Fl.H>
#include <FL/Fl_Check_Button.H>
#include <FL/fl_draw.H>

void Fl_Check_Button::draw() {
  draw_box(box(), /*Fl::belowmouse()==this ? FL_LIGHT1 :*/ FL_GRAY);
  int col = value() ? color2() : color();
  int d = h()/6;
  int W = w()<h() ? w() : h();
  fl_draw_box(value() ? FL_DIAMOND_DOWN_BOX : FL_DIAMOND_UP_BOX,
	      x()+d,y()+d+1,W-2*d-2,h()-2*d-2,col);
  draw_label(x()+W*3/4,y(),w()-W*3/4,h());
}

int Fl_Check_Button::handle(int event) {
  switch (event) {
  case FL_ENTER:
  case FL_LEAVE:
//  redraw();
  default:
    return Fl_Button::handle(event);
  }
}

Fl_Check_Button::Fl_Check_Button(int x,int y,int w,int h, const char *l)
: Fl_Button(x,y,w,h,l) {
  box(FL_NO_BOX);
//color(FL_WHITE, FL_YELLOW); // original Forms colors
  color2(FL_RED); // my colors (gray and red)
  align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
}
