/*	Fl_Bitmap.C

	Draw a bitmap in a box.

*/

#include <FL/Fl.H>
#include <FL/x.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Object.H>
#include <FL/Fl_Bitmap.H>

void fl_draw(Fl_Bitmap* b,int x,int y,int w,int h) {
  if (!b->id)
    b->id=XCreateBitmapFromData(fl_display,fl_window,
				(const char*)b->array,(b->w+7)&-8,b->h);
  XSetStipple(fl_display, fl_gc, b->id);
  int ox = x+(w-b->w)/2;
  int oy = y+(h-b->h)/2;
  XSetTSOrigin(fl_display, fl_gc, ox, oy);
  XSetFillStyle(fl_display, fl_gc, FillStippled);
  if (w > b->w) {x = ox; w = b->w;}
  if (h > b->h) {y = oy; h = b->h;}
  XFillRectangle(fl_display, fl_window, fl_gc, x, y, w, h);
  XSetFillStyle(fl_display, fl_gc, FillSolid);
}

Fl_Bitmap::~Fl_Bitmap() {
  if (id) XFreePixmap(fl_display, id);
}

static int bitmap_labeltype(
    const Fl_Label* o, int x, int y, int w, int h, uchar a)
{
  Fl_Bitmap* b = (Fl_Bitmap*)(o->value);
  if (a & FL_ALIGN_LEFT) w = b->w;
  else if (a & FL_ALIGN_RIGHT) {x += w-b->w; w = b->w;}
  if (a & FL_ALIGN_TOP) h = b->h;
  else if (a & FL_ALIGN_BOTTOM) {y += h-b->h; h = b->h;}
  fl_color(o->color);
  fl_draw(b,x,y,w,h);
  return 1;
}

void Fl_Bitmap::label(Fl_Object* o) {
  Fl::set_labeltype(_FL_BITMAP_LABEL, bitmap_labeltype);
  o->label(_FL_BITMAP_LABEL, (const char*)this);
}
