// fluid.C

// Please see README for some information about the construction of this
// rather nasty piece of code.

const char *copyright =
"The FL user interface designer version 0.98\n"
"Copyright (C) 1998 Digital Domain\n"
"\n"
"This library is free software; you can redistribute it and/or\n"
"modify it under the terms of the GNU Library General Public\n"
"License as published by the Free Software Foundation; either\n"
"version 2 of the License, or (at your option) any later version.\n"
"\n"
"This library is distributed in the hope that it will be useful,\n"
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"
"See the GNU Library General Public License for more details.\n"
"\n"
"You should have received a copy of the GNU Library General Public\n"
"License along with this library; if not, write to the Free\n"
"Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n"
"\n"
"Written by Bill Spitzak spitzak@d2.com\n"
"Digital Domain 300 Rose Avenue Venice, CA 90291";

#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Hold_Browser.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Input.H>
#include <FL/fl_ask.H>
#include <FL/fl_draw.H>
#include <FL/fl_file_chooser.H>
#include <FL/fl_message.H>
#include <FL/filename.H>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include "about_panel.H"

#include "Fl_Type.H"

////////////////////////////////////////////////////////////////

void nyi(Fl_Object *,void *) {
    fl_message("That's not yet implemented, sorry");
}

static const char *filename;
void set_filename(const char *c);
int modflag;

static char* pwd;
static char in_source_dir;
void goto_source_dir() {
  if (in_source_dir) return;
  if (!filename || !*filename) return;
  const char *p = filename_name(filename);
  if (p <= filename) return; // it is in the current directory
  char buffer[1024];
  strcpy(buffer,filename);
  int n = p-filename; if (n>1) n--; buffer[n] = 0;
  if (!pwd) {
    pwd = getcwd(0,1024);
    if (!pwd) {fprintf(stderr,"getwd : %s\n",strerror(errno)); return;}
  }
  if (chdir(buffer)<0) {fprintf(stderr, "Can't chdir to %s : %s\n",
				buffer, strerror(errno)); return;}
  in_source_dir = 1;
}

void leave_source_dir() {
  if (!in_source_dir) return;
  if (chdir(pwd)<0) {fprintf(stderr, "Can't chdir to %s : %s\n",
				pwd, strerror(errno));}
  in_source_dir = 0;
}
  
Fl_Window *main_window;

void atclose(Fl_Window* w, void* v) {
  if (!w || w == main_window) {
    if (!modflag || fl_ask("Exit without saving changes?")) exit(0);
  } else {
    Fl::default_atclose(w,v);
  }
}

void exit_cb(Fl_Object *,void *v) {
  atclose(0,v);
}

void save_cb(Fl_Object *, void *v) {
  const char *c = filename;
  if (v || !c || !*c) {
    if (!(c=fl_file_chooser("Save to:", "*.f[ld]", c))) return;
    set_filename(c);
  }
  if (!write_file(c)) {
    fl_show_message("Error writing", c, strerror(errno));
    return;
  }
  modflag = 0;
}

void open_cb(Fl_Object *, void *v) {
  if (!v && modflag && !fl_ask("Discard changes?")) return;
  const char *c;
  if (!(c = fl_file_chooser("Open:", "*.f[ld]", filename))) return;
  if (!read_file(c, v!=0)) {
    fl_show_message("Can't read", c, strerror(errno));
    return;
  }
  if (!v) {set_filename(c); modflag = 0;}
  else modflag = 1;
}

static int compile_only;

void write_cb(Fl_Object *, void *) {
  char cname[256];
  char hname[256];
  strcpy(cname,filename_name(filename)); filename_setext(cname,".C");
  strcpy(hname,filename_name(filename)); filename_setext(hname,".H");
  int x = write_code(cname,hname);
  strcat(cname, "/.H");
  if (compile_only) {
    if (!x) {fprintf(stderr,"%s : %s\n",cname,strerror(errno)); exit(1);}
  } else {
    if (!x) {
      fl_show_message("Can't write", cname, strerror(errno));
    } else {
      fl_show_message("Wrote", cname, 0);
    }
  }
}

void openobject_cb(Fl_Object *, void *) {
  if (!Fl_Type::current) {
    fl_message("Please select an object");
    return;
  }
  Fl_Type::current->open();
}

void toggle_overlays(Fl_Object *,void *);

void select_all_cb(Fl_Object *,void *);

void group_cb(Fl_Object *, void *);

void ungroup_cb(Fl_Object *, void *);

static const char *cutfname = "/usr/tmp/cut_buffer.fl";

extern int pasteoffset;
static int ipasteoffset;

void copy_cb(Fl_Object*, void*) {
  if (!Fl_Type::current) return;
  ipasteoffset = 5;
  if (!write_file(cutfname,1)) {
    fl_show_message("Can't write", cutfname, strerror(errno));
    return;
  }
}

extern void select_only(Fl_Type *);
void cut_cb(Fl_Object *, void *) {
  if (!Fl_Type::current) return;
  ipasteoffset = 0;
  Fl_Type *p = Fl_Type::current->parent;
  while (p && p->selected) p = p->parent;
  if (!write_file(cutfname,1)) {
    fl_show_message("Can't write", cutfname, strerror(errno));
    return;
  }
  delete_all(1);
  if (p) select_only(p);
}

extern int force_parent;

void paste_cb(Fl_Object*, void*) {
  if (ipasteoffset) force_parent = 1;
  pasteoffset = ipasteoffset;
  if (!read_file(cutfname, 1)) {
    fl_show_message("Can't read", cutfname, strerror(errno));
  }
  pasteoffset = 0;
  ipasteoffset += 5;
  force_parent = 0;
}

void earlier_cb(Fl_Object*,void*);

void later_cb(Fl_Object*,void*);

Fl_Type *sort(Fl_Type *parent);

static void sort_cb(Fl_Object *,void *) {
  sort((Fl_Type*)0);
}

void show_alignment_cb(Fl_Object *, void *);

void about_cb(Fl_Object *, void *) {
  make_about_panel(copyright);
  copyright_box->hide();
  display_group->show();
  about_panel->show();
}

////////////////////////////////////////////////////////////////

extern Fl_Menu New_Menu[];

Fl_Menu Main_Menu[] = {
{"/File"},
  {"Open...", "#O", open_cb, 0},
  {"Save", "#s", save_cb, 0},
  {"Save As...", "#S", save_cb, (void*)1},
  {"_Merge...", "#i", open_cb, (void*)1},
  {"Write code", "#C", write_cb, 0},
  {"Quit", "#q", exit_cb},
  {0},
{"/Edit"},
  {"Undo", "#z", nyi},
  {"Cut", "#xF12", cut_cb},
  {"Copy", "#cF9", copy_cb},
  {"Paste", "#vF10", paste_cb},
  {"_Select All", "#aF4", select_all_cb},
  {"Open...", "F1", openobject_cb},
  {"Sort",0,sort_cb},
  {"Earlier", "F2", earlier_cb},
  {"Later", "F3", later_cb},
//{"Show", "F5", show_cb},
//{"Hide", "F6", hide_cb},
  {"Group", "F7", group_cb},
  {"_Ungroup", "F8", ungroup_cb},
//{"Deactivate", 0, nyi},
//{"_Activate", 0, nyi},
  {"Overlays on/off","#o",toggle_overlays},
  {"Preferences","#p",show_alignment_cb},
  {0},
{"New", 0, 0, (void *)New_Menu, FL_PUP_SUBMENU},
{"/Help"},
  {"About fluid",0,about_cb},
  {"Manual",0,nyi},
  {0},
{0}};

Fl_Type *Fl_Type::current;

void Fl_Type::set_current(Fl_Type *o) {
  if (o == current) return;
  if (!o) {
    current = o;
  } else {
    o->set_current();
  }
}

void Fl_Type::set_current() {
  current = this;
}

#define BROWSERWIDTH 300
#define BROWSERHEIGHT 500
#define WINWIDTH 300
#define MENUHEIGHT 30
#define WINHEIGHT (BROWSERHEIGHT+MENUHEIGHT)

extern void fill_in_New_Menu();

void make_main_window() {
  if (!main_window) {
    Fl_Object *o;
    main_window = new Fl_Double_Window(WINWIDTH,WINHEIGHT,"fluid");
    main_window->box(FL_NO_BOX);
    o = make_object_browser(0,MENUHEIGHT,BROWSERWIDTH,BROWSERHEIGHT);
    o->box(FL_FLAT_BOX);
    main_window->add(o); main_window->resizable(o);
    Fl_Menu_Bar *m = new Fl_Menu_Bar(0,0,BROWSERWIDTH,MENUHEIGHT); m->menu(Main_Menu);
    main_window->add(m);
    o = new Fl_Box(FL_UP_BOX,BROWSERWIDTH,0,WINWIDTH-BROWSERWIDTH,MENUHEIGHT,"New:");
    o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    o->labelfont(Fl_Menu::textfont());
    main_window->add(o);
    fill_in_New_Menu();
  }
}

void set_filename(const char *c) {
  if (filename) free((void *)filename);
  filename = strdup(c);
  if (main_window) main_window->label(filename);
}

////////////////////////////////////////////////////////////////

static int arg(int, char** argv, int& i) {
  if (argv[i][1] == 'c' && !argv[i][2]) {compile_only = 1; i++; return 1;}
  return 0;
}

int main(int argc,char **argv) {
  int i = 1;
  if (!Fl::args(argc,argv,i,arg) || i < argc-1) {
    fprintf(stderr,"usage: %s <switches> name.fl\n -c : write .C and .H and exit\n%s\n", argv[0], Fl::help);
    return 1;
  }
  const char *c = argv[i];
  make_main_window();
  if (c) set_filename(c);
  if (!compile_only) {
    Fl::visual(FL_DOUBLE|FL_INDEX);
    main_window->show(argc,argv);
  }
  if (c && !read_file(c,0)) {
    if (compile_only) {
      fprintf(stderr,"%s : %s\n", c, strerror(errno));
      exit(1);
    }
    fl_show_message("Can't read", c, strerror(errno));
  }
  if (compile_only) {write_cb(0,0); exit(0);}
  modflag = 0;
  Fl::set_atclose(atclose);
  while (1) Fl::wait();
}
