// Fl_Object_Type.H

// Type for creating all subclasses of Fl_Object
// This should have the object pointer in it, but it is still in the
// Fl_Type base class.

#include "Fl_Type.H"

class Fl_Menu;
class Fluid_Image;

#define NUM_EXTRA_CODE 4

class Fl_Object_Type : public Fl_Type {
  virtual Fl_Object *object(int,int,int,int) = 0;
  virtual Fl_Object_Type *_make() = 0; // virtual constructor
  virtual void setlabel(const char *);
  void write_declare();
  void write_static();
  void write_code();

  const char *callback_name();
  const char *extra_code_[NUM_EXTRA_CODE];
  const char *subclass_;
  uchar resizable_, hotspot_;

protected:

  void write_object_code();

public:

  Fluid_Image *image;
  void setimage(Fluid_Image *);

  Fl_Object_Type();
  Fl_Type *make();
  void open();

  const char *extra_code(int n) const {return extra_code_[n];}
  void extra_code(int n,const char *);
  const char *subclass() const {return subclass_;}
  void subclass(const char *);
  uchar resizable() const {return resizable_;}
  void resizable(uchar v) {resizable_ = v;}
  uchar hotspot() const {return hotspot_;}
  void hotspot(uchar v) {hotspot_ = v;}

  virtual int textstuff(int what, uchar &, uchar &, uchar &);
  virtual Fl_Menu *subtypes();

  virtual void write_properties();
  virtual void read_property(const char *);
  virtual int read_fdesign(const char*, const char*);
};

void* const LOAD = (void *)9831;
extern Fl_Object_Type *current_object; // one of the selected ones
